--[[
LockSteeringAxlesLoader

This script registers and loads LockSteeringAxles specialization for all vehicles that have the attachable specialization.
	@author: 	[LSFM] BayernGamers
	@date: 		06.11.2024
	@version:	1.0

	History:	v1.0 @07.11.2024 - initial implementation in FS 22
				-------------------------------------------------------------------------------------------

    License: 	This work is licensed under the Creative Commons Attribution-NoDerivs 4.0 International License (CC BY-ND 4.0).

                Terms:
                    Attribution:
                        You must give appropriate credit to the original author when using this work.
                    No Derivatives:
                        You may not alter, transform, or build upon this work in any way.
                    Usage: 
                        The work may be used for personal and commercial purposes, provided it is not modified or adapted.

                    Additional Clause:
                        This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.

                    Full License Text:
                        The complete license text can be found at: https://creativecommons.org/licenses/by-nd/4.0/
]]

source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil

LockSteeringAxlesLoader = {}
LockSteeringAxlesLoader.debugLevel = 1
LockSteeringAxlesLoader.MOD_DIRECTORY = g_currentModDirectory

if g_specializationManager:getSpecializationByName("LockSteeringAxles") == nil then
	g_specializationManager:addSpecialization('lockSteeringAxles', 'LockSteeringAxles', Utils.getFilename('LockSteeringAxles.lua', LockSteeringAxlesLoader.MOD_DIRECTORY .. "scripts/"), nil)
    log.printDevInfo("Added specialization 'lockSteeringAxles'", LockSteeringAxlesLoader.debugLevel, true, "LockSteeringAxlesLoader.lua")
end

for vehicleTypeName, vehicleType in pairs(g_vehicleTypeManager.types) do
    if vehicleType ~= nil and not SpecializationUtil.hasSpecialization(LockSteeringAxles, vehicleType.specializations) and SpecializationUtil.hasSpecialization(Attachable, vehicleType.specializations) then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'lockSteeringAxles')
        log.printInfo("Added lockSteeringAxles to " .. vehicleTypeName)
    end
end