--[[
AutoTurnOffTurnLightsLoader

This script registers and loads the AutoTurnOffTurnLights specialization for all vehicles that have the TurnLight specialization.

	@author: 	[LSFM] BayernGamers
	@date: 		06.11.2024
	@version:	1.0

	History:	v1.0 @06.11.2024 - initial implementation in FS 22
				-------------------------------------------------------------------------------------------

    License: 	This work is licensed under the Creative Commons Attribution-NoDerivs 4.0 International License (CC BY-ND 4.0).

                Terms:
                    Attribution:
                        You must give appropriate credit to the original author when using this work.
                    No Derivatives:
                        You may not alter, transform, or build upon this work in any way.
                    Usage: 
                        The work may be used for personal and commercial purposes, provided it is not modified or adapted.

                    Additional Clause:
                        This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.

                    Full License Text:
                        The complete license text can be found at: https://creativecommons.org/licenses/by-nd/4.0/
]]

source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil

AutoTurnOffTurnLightsLoader = {}
AutoTurnOffTurnLightsLoader.debugLevel = 1
AutoTurnOffTurnLightsLoader.MOD_DIRECTORY = g_currentModDirectory

if g_specializationManager:getSpecializationByName("AutoTurnOffTurnLights") == nil then
	g_specializationManager:addSpecialization('autoTurnOffTurnLights', 'AutoTurnOffTurnLights', Utils.getFilename('AutoTurnOffTurnLights.lua', AutoTurnOffTurnLightsLoader.MOD_DIRECTORY .. "scripts/"), nil)
    log.printDevInfo("Added specialization 'autoTurnOffTurnLights'", AutoTurnOffTurnLightsLoader.debugLevel, true, "AutoTurnOffTurnLightsLoader.lua")
end

for vehicleTypeName, vehicleType in pairs(g_vehicleTypeManager.types) do
    if vehicleType ~= nil and not SpecializationUtil.hasSpecialization(AutoTurnOffTurnLights, vehicleType.specializations) and SpecializationUtil.hasSpecialization(Drivable, vehicleType.specializations) then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'autoTurnOffTurnLights')
        log.printInfo("Added autoTurnOffTurnLights to " .. vehicleTypeName)
    end
end