CustomExhaustEffect = {}

CustomExhaustEffect.smokeOpacity = 5 -- Opacité de la fumée

function CustomExhaustEffect.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations)
end

function CustomExhaustEffect.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "onExhaustEffectI3DLoaded", CustomExhaustEffect.onExhaustEffectI3DLoaded)
end

function CustomExhaustEffect:onExhaustEffectI3DLoaded(superFunc, i3dNode, failedReason, args)
    local spec = self.spec_motorized
    superFunc(self, i3dNode, failedReason, args)

    -- Applique la couleur de fumée noire sur les effets d'échappement
    if spec.exhaustEffects ~= nil then
        for _, effect in pairs(spec.exhaustEffects) do
            effect.minRpmColor = {0, 0, 0, CustomExhaustEffect.smokeOpacity}
            effect.maxRpmColor = {0, 0, 0, CustomExhaustEffect.smokeOpacity}
        end
    end
end

