--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 28.10.2022
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Free for use in mods (FS22 Only) - no permission needed.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Frei verwendbar (Nur LS22) - keine erlaubnis nötig
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

EnterableEnterText = {}

EnterableEnterText.MOD_NAME = g_currentModName or ""
EnterableEnterText.SPEC_NAME = string.format("spec_%s.enterableEnterText", g_currentModName)

function EnterableEnterText.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Enterable, specializations)
end

function EnterableEnterText.initSpecialization()
    local schema = Vehicle.xmlSchema

    schema:setXMLSpecializationType("EnterableEnterText")

    schema:register(XMLValueType.STRING, "vehicle.enterable#enterText", "$l10n_button_enterVehicle")
    schema:register(XMLValueType.STRING, "vehicle.enterable#enterTextParams", "Optional parameters that will be formatted into #enterText")

    schema:setXMLSpecializationType()

    -- Only need to overwrite this once so all mods using spec will work...
    if Player.ENTERABLE_GET_CUSTOM_ENTER_TEXT_ADDED == nil then
        Player.ENTERABLE_GET_CUSTOM_ENTER_TEXT_ADDED = true

        Player.updateActionEvents = Utils.appendedFunction(Player.updateActionEvents, function (self)
            if self.canEnterVehicle and self.inputInformation.registrationList[InputAction.ENTER].lastState then
                local vehicle = g_currentMission.interactiveVehicleInRange

                if vehicle ~= nil and vehicle.spec_enterableEnterText and vehicle.getCustomEnterText ~= nil and vehicle:getIsEnterable() then
                    local customEnterText = vehicle:getCustomEnterText()

                    if customEnterText ~= nil then
                        g_inputBinding:setActionEventText(self.inputInformation.registrationList[InputAction.ENTER].eventId, customEnterText)
                    end
                end
            end
        end)
    end
end

function EnterableEnterText.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "getCustomEnterText", EnterableEnterText.getCustomEnterText)
end

function EnterableEnterText.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", EnterableEnterText)
end

function EnterableEnterText:onLoad(savegame)
    self.spec_enterableEnterText = self[EnterableEnterText.SPEC_NAME]

    local spec = self.spec_enterableEnterText

    if spec ~= nil then
        local enterText = self.xmlFile:getValue("vehicle.enterable#enterText", "$l10n_button_enterVehicle")

        if enterText ~= nil and enterText:trim() ~= "" then
            local customEnv = self.customEnvironment or EnterableEnterText.MOD_NAME
            local params = self.xmlFile:getValue("vehicle.enterable#enterTextParams")

            if params ~= nil then
                params = params:split("|")

                for i = 1, #params do
                    params[i] = g_i18n:convertText(params[i], customEnv)
                end

                enterText = string.format(enterText, unpack(params))
            end

            spec.text = g_i18n:convertText(enterText, customEnv)
        else
            spec.text = g_i18n:getText("button_enterVehicle")
        end
    else
        Logging.error("[%s] Specialization with name 'enterableEnterText' was not found in modDesc!", EnterableEnterText.MOD_NAME)
    end
end

function EnterableEnterText:getCustomEnterText()
    local spec = self.spec_enterableEnterText

    if spec == nil or spec.text == nil then
        return g_i18n:getText("button_enterVehicle")
    end

    return spec.text
end
