-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 11.11.2025

PlaceableCookerHUD = {}
PlaceableCookerHUD.modDirectory = g_currentModDirectory or ""
PlaceableCookerHUD.INSTANCE = nil

local PlaceableCookerHUD_mt = Class(PlaceableCookerHUD, MessageDialog)

local function _norm(raw)
    if not raw or raw=="" then return "" end
    if raw:sub(1,1) ~= "$" then return raw end
    local k = raw:sub(2)
    if g_i18n and g_i18n.hasText and g_i18n:hasText(k) then return g_i18n:getText(k) end
    if k:sub(1,5)=="l10n_" and g_i18n and g_i18n:hasText(k:sub(6)) then return g_i18n:getText(k:sub(6)) end
    return k
end

local function _getLiveFarmerBaseDir_PC()
    local candidates = {}

    if PlaceableCooker and PlaceableCooker.modDirectory and PlaceableCooker.modDirectory ~= "" then
        table.insert(candidates, PlaceableCooker.modDirectory)
    end
    if PlaceableCookerHUD.modDirectory and PlaceableCookerHUD.modDirectory ~= "" then
        table.insert(candidates, PlaceableCookerHUD.modDirectory)
    end

    if g_modManager ~= nil then
        if g_modManager.getModByName ~= nil then
            local m = g_modManager:getModByName("FS25_liveFarmer")
            if m ~= nil then
                local dir = m.modDir or m.modDirectory or m.absolutePath or m.path or m.directory
                if dir and dir ~= "" then
                    table.insert(candidates, dir)
                end
            end
        end
        if g_modManager.mods ~= nil then
            for _, m in pairs(g_modManager.mods) do
                local name     = m.modName or m.name or ""
                local fileName = m.modFileName or ""
                if name == "FS25_liveFarmer" or fileName:lower():find("fs25_livefarmer") ~= nil then
                    local dir = m.modDir or m.modDirectory or m.absolutePath or m.path or m.directory
                    if dir and dir ~= "" then
                        table.insert(candidates, dir)
                    end
                end
            end
        end
    end

    if debug and debug.getinfo then
        local info = debug.getinfo(_getLiveFarmerBaseDir_PC, "S")
        if info and info.source then
            local src = info.source
            if src:sub(1,1) == "@" then src = src:sub(2) end
            src = src:gsub("\\", "/")
            local idx = src:lower():find("/fs25_livefarmer/")
            if idx then
                local dir = src:sub(1, idx + string.len("/FS25_liveFarmer/") - 1)
                table.insert(candidates, dir)
            end
        end
    end

    if g_modsDirectory ~= nil then
        table.insert(candidates, g_modsDirectory .. "/FS25_liveFarmer/")
    end

    local tried = {}
    for _, baseDir in ipairs(candidates) do
        if type(baseDir) == "string" and baseDir ~= "" then
            baseDir = baseDir:gsub("\\", "/")
            if baseDir:sub(-1) ~= "/" then
                baseDir = baseDir .. "/"
            end
            if not tried[baseDir] then
                tried[baseDir] = true
                local testPath = Utils.getFilename("gui/PlaceableCookerHUD.xml", baseDir)
                if testPath and fileExists(testPath) then
                    return baseDir
                end
            end
        end
    end

    return PlaceableCookerHUD.modDirectory or (g_currentModDirectory or "")
end

function PlaceableCookerHUD.register()
    if not g_gui then return false end

    if g_gui.guis and g_gui.guis["PlaceableCookerHUD"] then
        PlaceableCookerHUD.INSTANCE = g_gui.guis["PlaceableCookerHUD"].target
        return true
    end

    local inst = PlaceableCookerHUD.new()

    local baseDir = _getLiveFarmerBaseDir_PC()
    baseDir = baseDir or ""
    baseDir = baseDir:gsub("\\", "/")
    if baseDir ~= "" and baseDir:sub(-1) ~= "/" then
        baseDir = baseDir .. "/"
    end

    local xmlPath = Utils.getFilename("gui/PlaceableCookerHUD.xml", baseDir)
    local ok = false

    if xmlPath and xmlPath ~= "" then
        ok = pcall(function()
            g_gui:loadGui(xmlPath, "PlaceableCookerHUD", inst)
        end)
    end

    if (not ok) or not (g_gui.guis and g_gui.guis["PlaceableCookerHUD"]) then
        local path1 = baseDir .. "gui/PlaceableCookerHUD.xml"
        local path2 = baseDir .. "PlaceableCookerHUD.xml"
        for _, p in ipairs({path1, path2}) do
            if p and p ~= "" then
                local loaded = pcall(function()
                    g_gui:loadGui(p, "PlaceableCookerHUD", inst)
                end)
                if loaded and g_gui.guis and g_gui.guis["PlaceableCookerHUD"] then
                    ok = true
                    xmlPath = p
                    break
                end
            end
        end
    end

    if not ok or not (g_gui.guis and g_gui.guis["PlaceableCookerHUD"]) then
        pcall(function() inst:delete() end)
        print("[PlaceableCookerHUD] XML not found (baseDir=" .. tostring(baseDir) .. ", xmlPath=" .. tostring(xmlPath) .. ")")
        return false
    end

    PlaceableCookerHUD.INSTANCE = g_gui.guis["PlaceableCookerHUD"].target
    return true
end


function PlaceableCookerHUD.new(target, custom_mt)
    local self = MessageDialog.new(target, custom_mt or PlaceableCookerHUD_mt)
    self.placeable     = nil
    self.items         = {}
    self.selectedIndex = 0
    self.itemsTable    = nil
    self.itemsSlider   = nil
    self.btnCook       = nil
    self.btnEat        = nil
    self.btnTake       = nil
    self.btnDiscard    = nil
    self.header        = nil
    self.descText      = nil
    self._tick         = 0
    self._finalizeSent = false
    self._pendingStart = 0
    return self
end

function PlaceableCookerHUD:onOpen()
    local sc = self.superClass and self:superClass()
    if sc and sc.onOpen then sc.onOpen(self) end

    self.itemsTable = self:getDescendantById("itemsTable")
    self.itemsSlider= self:getDescendantById("itemsTableSlider")
    self.btnCook    = self:getDescendantById("cookButton")
    self.btnEat     = self:getDescendantById("eatButton")
    self.btnTake    = self:getDescendantById("takeButton")
    self.btnDiscard = self:getDescendantById("discardButton")
    self.descTitle  = self:getDescendantById("itemDescTitle")
    self.statusText = self:getDescendantById("dialogTitleElement2")
    self.descText   = self:getDescendantById("itemDesc")
    self.header     = self:getDescendantById("dialogTitleElement")

    self:updateHeader()
    self:pullData()
    if self.selectedIndex == 0 and #self.items > 0 then self.selectedIndex = 1 end
    self:updateButtons()
    self._tick = 0
end

function PlaceableCookerHUD:onClose()
    self.items = {}
    self.selectedIndex = 0
    MessageDialog.onClose(self)
end

function PlaceableCookerHUD:update(dt)
    local sc = self.superClass and self:superClass()
    if sc and sc.update then sc.update(self, dt) end
    self._tick = (self._tick or 0) - (dt or 0)
    if self._tick <= 0 then
        self._tick = 250
        self:updateStatusText()
    end
end

function PlaceableCookerHUD:updateHeader()
    local title = (self.placeable and self.placeable.spec_placeableCooker and self.placeable.spec_placeableCooker.title)
                  or (g_i18n and g_i18n:getText("ui_pcooker_title")) or "Кухня"
    if self.header and self.header.setText then self.header:setText(title) end
end

function PlaceableCookerHUD:pullData(preserveSelection)
    local prevIndex  = self.selectedIndex or 0
    local tableElem  = self.itemsTable
    local firstVis   = tableElem and tableElem.getFirstVisibleItem and tableElem:getFirstVisibleItem() or nil

    self.items = {}
    local spec = self.placeable and self.placeable.spec_placeableCooker
    if spec then
        for i, it in ipairs(spec.items) do
            local name    = _norm(it.name)
            local h       = tonumber(it.hungerGain) or 0
            local v       = tonumber(it.vigorGain) or 0
            local cookSec = tonumber(it.cookSec)   or 0
            local priceVal= math.max(0, tonumber(it.price) or 0)
            local cap     = math.max(0, tonumber(it.readyCap) or 0)
            local have    = 0
            if spec.readyCounts and spec.readyCounts[i] then
                have = spec.readyCounts[i]
            elseif spec.readyItems and #spec.readyItems > 0 then
                for _,p in ipairs(spec.readyItems) do
                    if (p.index or 0) == i then have = have + 1 end
                end
            end

            local lblH = (g_i18n and g_i18n:getText("ui_foodVendor_hungerShort")) or "Сытость"
            local lblV = (g_i18n and g_i18n:getText("ui_foodVendor_vigorShort"))  or "Бодрость"
            local lblT = (g_i18n and g_i18n:getText("ui_cooker_cooktime"))        or "Время"
            local lblP = (g_i18n and g_i18n:getText("ui_pcooker_price"))          or "Цена"
            local lblR = (g_i18n and g_i18n:getText("ui_pcooker_readyStored"))    or "Готовое"

            local priceText = (priceVal <= 0)
                and ((g_i18n and g_i18n:getText("ui_pcooker_free")) or "Бесплатно")
                or string.format("%d $", priceVal)
            local capText   = (cap > 0) and tostring(cap) or "∞"
            local readyText = string.format("%s: %d/%s", lblR, have, capText)

            local parts = {}
            table.insert(parts, string.format("%s: %ds", lblT, cookSec))
            table.insert(parts, readyText)
            table.insert(parts, string.format("%s: %s", lblP, priceText))
            table.insert(parts, string.format("%s: %+d%%", lblH, h))
            if v ~= 0 then table.insert(parts, string.format("%s: %+d%%", lblV, v)) end

            table.insert(self.items, {
                index   = i,
                have    = have,
                cap     = cap,
                display = string.format("%s — %s", name, table.concat(parts, ", ")),
                name    = it.name,
                desc    = _norm(it.desc or ""),
                icon    = it.icon,
                kind    = it.kind or "food",
                effectId= it.effectId
            })
        end
    end

    if self.itemsTable then
        self.itemsTable:reloadData(true)
        if preserveSelection and prevIndex > 0 and prevIndex <= #self.items then
            self.selectedIndex = prevIndex
            self.itemsTable:setSelectedIndex(prevIndex, true, false)
            if firstVis and self.itemsTable.scrollTo then
                self.itemsTable:scrollTo(firstVis-1, false)
            end
        else
            if #self.items > 0 then
                self.selectedIndex = math.min(prevIndex > 0 and prevIndex or 1, #self.items)
                self.itemsTable:setSelectedIndex(self.selectedIndex, true, true)
                if self.itemsTable.scrollTo then self.itemsTable:scrollTo(self.selectedIndex-1, false) end
            else
                self.selectedIndex = 0
            end
        end
    end

    if self.selectedIndex > 0 and self.items[self.selectedIndex] then
        local it = self.items[self.selectedIndex]
        if self.descTitle then self.descTitle:setText(_norm(it.name)) end
        if self.descText  then self.descText:setText(it.desc or "") end
    else
        if self.descTitle then self.descTitle:setText("") end
        if self.descText  then self.descText:setText("") end
    end

    self:updateButtons()
end


function PlaceableCookerHUD:updateButtons()
    local spec = self.placeable and self.placeable.spec_placeableCooker
    if not spec then return end

    local cooking  = (spec.state and spec.state.cooking) or false
    local hasReady = false
    if spec.readyItems and #spec.readyItems > 0 then
        hasReady = true
    elseif (spec.readyCount or 0) > 0 then
        hasReady = true
    elseif spec.state and spec.state.ready then
        hasReady = true
    end

    if self.btnEat  then self.btnEat:setDisabled(not hasReady) end
    if self.btnTake then self.btnTake:setDisabled(not hasReady) end

    if self.btnDiscard then self.btnDiscard:setDisabled(not (hasReady or cooking)) end

    local canCook = not cooking
    if self.selectedIndex > 0 and self.items[self.selectedIndex] then
        local it = self.items[self.selectedIndex]
        if (it.cap or 0) > 0 and (it.have or 0) >= it.cap then
            canCook = false
        end
    end
    if self.btnCook then self.btnCook:setDisabled(not canCook) end
end

function PlaceableCookerHUD:updateStatusText()
    local spec = self.placeable and self.placeable.spec_placeableCooker
    if not spec then return end

    local st = spec.state or {}
    if st.cooking then
        local remainMs = math.max(0, (st.endTimeMs or 0) - (g_time or 0))
        if remainMs <= 0 and not self._finalizeSent then
            self._finalizeSent = true
            if g_client ~= nil then
                local conn = g_client:getServerConnection()
                if conn then conn:sendEvent(PCC_FinalizeEvent.new(self.placeable)) end
            else
                if self.placeable.pcServerFinalizeIfReady then self.placeable:pcServerFinalizeIfReady() end
                self:pullData(true)
            end
        end

        local sec   = math.floor(remainMs/1000)
        local label = (g_i18n and g_i18n:getText("ui_cooker_status_cooking")) or "Готовим"

        if self.statusText then self.statusText:setText(string.format("%s: %ds", label, sec)) end

        self:updateButtons()
        return
    end

    self._finalizeSent = nil

    local readyCount = (spec.readyItems and #spec.readyItems) or (spec.readyCount or 0)
    local statusStr
    if (readyCount > 0) or (st.ready and readyCount == 0) then
        local base = (g_i18n and g_i18n:getText("ui_pcooker_status_ready")) or "Готово — можно съесть или забрать"
        statusStr = (readyCount > 0) and string.format("%s (x%d)", base, readyCount) or base
    elseif st.spoiled then
        statusStr = (g_i18n and g_i18n:getText("ui_cooker_status_spoiled")) or "Испорчено — можно только выкинуть"
    else
        statusStr = (g_i18n and g_i18n:getText("ui_cooker_status_idle")) or "Пусто"
    end

    if self.statusText then self.statusText:setText(statusStr) end

    self:updateButtons()
end

function PlaceableCookerHUD:getNumberOfSections(list) return 1 end
function PlaceableCookerHUD:getNumberOfItemsInSection(list, sectionIndex) return #self.items end
function PlaceableCookerHUD:getCellTypeForItemInSection(list, sectionIndex, indexInSection) return "rowTemplate" end

function PlaceableCookerHUD:populateCellForItemInSection(list, sectionIndex, indexInSection, cell)
    local data = self.items[indexInSection]; if not data then return end
    local rowText = cell:getAttribute("rowText") or cell:getDescendantByName("rowText") or cell:getDescendantById("rowText")
    if rowText then rowText:setText(string.format("%s", _norm(data.display))) end

    local iconElem = cell:getAttribute("rowIcon") or cell:getDescendantByName("rowIcon") or cell:getDescendantById("rowIcon")
    if iconElem then
        local path = data.icon
        if path and fileExists(path) then
            iconElem:setVisible(true)
            if iconElem.setImageFilename then iconElem:setImageFilename(path) end
        else
            iconElem:setVisible(false)
        end
    end
end

function PlaceableCookerHUD:onListSelectionChanged(list, sectionIndex, indexInSection)
    self.selectedIndex = indexInSection or 0

    if self.selectedIndex > 0 and self.items[self.selectedIndex] then
        local it = self.items[self.selectedIndex]
        if self.descTitle then self.descTitle:setText(_norm(it.name)) end
        if self.descText  then self.descText:setText(it.desc or "") end
    else
        if self.descTitle then self.descTitle:setText("") end
        if self.descText  then self.descText:setText("") end
    end
    self:updateStatusText()
end

-- Кнопки
function PlaceableCookerHUD:onClickCook()
    if not (self.placeable and self.selectedIndex > 0) then return end
    local item = self.items[self.selectedIndex]; if not item then return end
    self._pendingStart = 1200
    if self.descText then self.descText:setText(g_i18n and g_i18n:getText("ui_cooker_status_cooking") or "Готовим") end
    self:updateButtons()
    if g_client ~= nil then
        local conn = g_client:getServerConnection()
        if conn then conn:sendEvent(PCC_StartCookEvent.new(self.placeable, item.index)) end
    else
        self.placeable:pcServerStartCook(item.index, g_currentMission:getFarmId())
    end
end

function PlaceableCookerHUD:onClickEat()
    if not self.placeable then return end
    local idx = (self.selectedIndex or 0)
    if idx <= 0 then return end

    if g_client ~= nil then
        local conn = g_client:getServerConnection()
        if conn then conn:sendEvent(PCC_ConsumeEvent.new(self.placeable, idx)) end
    else
        local ok, payload = self.placeable:pcServerConsumeCooked(g_currentMission:getFarmId(), idx)
        self:pullData(true)
    end
end

function PlaceableCookerHUD:onClickTake()
    if not self.placeable then return end
    local idx = (self.selectedIndex or 0)
    if idx <= 0 then return end

    if g_client ~= nil then
        local conn = g_client:getServerConnection()
        if conn then conn:sendEvent(PCC_TakeToInventoryEvent.new(self.placeable, idx)) end
    else
        local ok, payload = self.placeable:pcServerTakeToInventory(g_currentMission:getFarmId(), idx)
        self:pullData(true)
    end
end

function PlaceableCookerHUD:onClickDiscard()
    if not self.placeable then return end
    if g_client ~= nil then
        local conn = g_client:getServerConnection()
        if conn then conn:sendEvent(PCC_DiscardEvent.new(self.placeable)) end
    else
        self.placeable:pcServerDiscardCooked(g_currentMission:getFarmId())
    end
    self:updateButtons()
end

function PlaceableCookerHUD:onClickClose()
    self:close()
end
