-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 11.11.2025

if _G.PCC_StateSyncEvent == nil then
    PCC_StateSyncEvent = {}
    local mt = Class(PCC_StateSyncEvent, Event)
    InitEventClass(PCC_StateSyncEvent, "PCC_StateSyncEvent")

    function PCC_StateSyncEvent.emptyNew() return Event.new(mt) end
    function PCC_StateSyncEvent.new(placeable, state, currentIndex)
        local self = PCC_StateSyncEvent.emptyNew()
        self.placeable    = placeable
        self.state        = state or {}
        self.currentIndex = currentIndex or -1
        return self
    end

	function PCC_StateSyncEvent:writeStream(streamId, connection)
		NetworkUtil.writeNodeObject(streamId, self.placeable)
		if not self.placeable then return end

		local spec = self.placeable.spec_placeableCooker
		local st   = spec and spec.state or {}

		local now         = g_time or 0
		local remainingMs = math.max(0, (st.endTimeMs or 0) - now)

		-- базовое состояние
		streamWriteBool(streamId, st.cooking == true)
		streamWriteBool(streamId, st.ready   == true)
		streamWriteBool(streamId, st.spoiled == true)
		streamWriteInt32(streamId, remainingMs)
		streamWriteInt32(streamId, st.endTimeMs or 0)
		streamWriteInt16(streamId, st.cookedDay or -1)
		streamWriteInt16(streamId, (st.current and st.current.index) or -1)

		local readyCount = spec and (spec.readyCount or (#spec.readyItems or 0)) or 0
		streamWriteInt16(streamId, readyCount)

		local numRecipes = (spec and spec.items and #spec.items) or 0
		streamWriteUInt16(streamId, numRecipes)
		if numRecipes > 0 then
			for i = 1, numRecipes do
				local c = (spec.readyCounts and spec.readyCounts[i]) or 0
				streamWriteUInt16(streamId, c)
			end
		end
	end

	function PCC_StateSyncEvent:readStream(streamId, connection)
		self.placeable = NetworkUtil.readNodeObject(streamId)
		if not self.placeable then return end

		local spec = self.placeable.spec_placeableCooker
		if not spec then return end

		local st = spec.state or {}
		spec.state = st

		local cooking      = streamReadBool(streamId)
		local readyFlag    = streamReadBool(streamId)
		local spoiled      = streamReadBool(streamId)
		local remainingMs  = streamReadInt32(streamId)
		local endTimeMs    = streamReadInt32(streamId)
		local cookedDay    = streamReadInt16(streamId)
		local curIndex     = streamReadInt16(streamId)

		st.cooking   = cooking
		st.spoiled   = spoiled
		st.endTimeMs = (g_time or 0) + remainingMs
		st.cookedDay = cookedDay

		if curIndex and curIndex > 0 and spec.items and spec.items[curIndex] then
			st.current = spec.items[curIndex]
		else
			st.current = nil
		end

		-----------------------------------------------------------------------
		-- счётчики готового
		-----------------------------------------------------------------------
		spec.readyCount  = streamReadInt16(streamId) or 0
		local numRecipes = streamReadUInt16(streamId) or 0

		spec.readyCounts = spec.readyCounts or {}
		for i = 1, numRecipes do
			spec.readyCounts[i] = streamReadUInt16(streamId) or 0
		end

		st.ready = (spec.readyCount or 0) > 0 or readyFlag

		if self.placeable._pcApplyCookAnimFromState then
			self.placeable:_pcApplyCookAnimFromState()
		end

		if PlaceableCookerHUD and PlaceableCookerHUD.INSTANCE and PlaceableCookerHUD.INSTANCE.placeable == self.placeable then
			PlaceableCookerHUD.INSTANCE:pullData(true)
			PlaceableCookerHUD.INSTANCE:updateStatusText()
		end
	end


    function PCC_StateSyncEvent:run(connection)
        local p = self.placeable
        if p == nil or p.spec_placeableCooker == nil then return end
        local spec = p.spec_placeableCooker

        spec.state.cooking   = self.state.cooking
        spec.state.ready     = self.state.ready
        spec.state.spoiled   = self.state.spoiled
        spec.state.endTimeMs = self.state.endTimeMs or 0
        spec.state.cookedDay = self.state.cookedDay or -1

        if self.currentIndex and self.currentIndex > 0 and spec.items[self.currentIndex] then
            spec.state.current = spec.items[self.currentIndex]
            spec.state.current.index = self.currentIndex
        else
            if not spec.state.cooking then
                spec.state.current = nil
            end
        end

        if p._pcApplyCookAnimFromState then
            p:_pcApplyCookAnimFromState()
        end

        if _G.PlaceableCookerHUD and PlaceableCookerHUD.INSTANCE
            and PlaceableCookerHUD.INSTANCE.placeable == p
            and g_gui and g_gui:getIsGuiVisible() then
            local hud = PlaceableCookerHUD.INSTANCE
            hud:pullData(true)
            hud:updateStatusText()
            hud:updateButtons()
        end
    end



    function PCC_StateSyncEvent.send(placeable)
        if g_server then
            local spec = placeable.spec_placeableCooker
            local idx  = (spec.state.current and spec.state.current.index) or -1
            g_server:broadcastEvent(PCC_StateSyncEvent.new(placeable, spec.state, idx), true, nil, placeable)
        end
    end
end

-- =======================
if _G.PCC_StartCookEvent == nil then
    PCC_StartCookEvent = {}
    local mt = Class(PCC_StartCookEvent, Event)
    InitEventClass(PCC_StartCookEvent, "PCC_StartCookEvent")
    function PCC_StartCookEvent.emptyNew() return Event.new(mt) end
    function PCC_StartCookEvent.new(placeable, itemIndex)
        local self=PCC_StartCookEvent.emptyNew(); self.placeable=placeable; self.itemIndex=itemIndex or 1; return self
    end
    function PCC_StartCookEvent:writeStream(streamId, connection)
        NetworkUtil.writeNodeObject(streamId, self.placeable)
        streamWriteUInt16(streamId, self.itemIndex or 1)
    end
    function PCC_StartCookEvent:readStream(streamId, connection)
        self.placeable=NetworkUtil.readNodeObject(streamId)
        self.itemIndex=streamReadUInt16(streamId)
        self:run(connection)
    end
	function PCC_StartCookEvent:run(connection)
		if g_server ~= nil and self.placeable and self.placeable.pcServerStartCook then
			local farmId = 1
			if HungerSystem and HungerSystem.getFarmIdFromConnection then
				farmId = HungerSystem.getFarmIdFromConnection(connection)
			elseif g_currentMission and g_currentMission.getFarmId then
				farmId = g_currentMission:getFarmId() or 1
			end

			local ok = self.placeable:pcServerStartCook(self.itemIndex, farmId)
			if ok then
				PCC_StateSyncEvent.send(self.placeable)
			end
		end
	end
end

-- =======================
if _G.PCC_FinalizeEvent == nil then
    PCC_FinalizeEvent = {}
    local mt = Class(PCC_FinalizeEvent, Event)
    InitEventClass(PCC_FinalizeEvent, "PCC_FinalizeEvent")
    function PCC_FinalizeEvent.emptyNew() return Event.new(mt) end
    function PCC_FinalizeEvent.new(placeable) local self=PCC_FinalizeEvent.emptyNew(); self.placeable=placeable; return self end
    function PCC_FinalizeEvent:writeStream(streamId, connection) NetworkUtil.writeNodeObject(streamId, self.placeable) end
    function PCC_FinalizeEvent:readStream(streamId, connection)  self.placeable=NetworkUtil.readNodeObject(streamId); self:run(connection) end
    function PCC_FinalizeEvent:run(connection)
        if self.placeable and self.placeable.pcServerFinalizeIfReady then
            self.placeable:pcServerFinalizeIfReady()
            PCC_StateSyncEvent.send(self.placeable)
        end
    end
end

-- =======================
if _G.PCC_ConsumeEvent == nil then
    PCC_ConsumeEvent = {}
    local mt = Class(PCC_ConsumeEvent, Event)
    InitEventClass(PCC_ConsumeEvent, "PCC_ConsumeEvent")

    function PCC_ConsumeEvent.emptyNew() return Event.new(mt) end
    function PCC_ConsumeEvent.new(placeable, recipeIndex)
        local self = PCC_ConsumeEvent.emptyNew()
        self.placeable   = placeable
        self.recipeIndex = recipeIndex or 0
        return self
    end

    function PCC_ConsumeEvent:writeStream(streamId, connection)
        NetworkUtil.writeNodeObject(streamId, self.placeable)
        streamWriteUInt16(streamId, self.recipeIndex or 0)
    end

    function PCC_ConsumeEvent:readStream(streamId, connection)
        self.placeable   = NetworkUtil.readNodeObject(streamId)
        self.recipeIndex = streamReadUInt16(streamId)
        self:run(connection)
    end

	function PCC_ConsumeEvent:run(connection)
		if g_server ~= nil and self.placeable and self.placeable.pcServerConsumeCooked then
			local farmId = 1
			if HungerSystem and HungerSystem.getFarmIdFromConnection then
				farmId = HungerSystem.getFarmIdFromConnection(connection)
			elseif g_currentMission and g_currentMission.player then
				farmId = g_currentMission.player.farmId or 1
			end

			local ok, payload = self.placeable:pcServerConsumeCooked(farmId, self.recipeIndex)
			if not ok then
				return
			end

			PCC_StateSyncEvent.send(self.placeable)

			local clientEvent
			if FoodVendorGainHungerEvent and FoodVendorGainHungerEvent.new then
				clientEvent = FoodVendorGainHungerEvent.new(payload)
			elseif FoodVendorBuyToInventoryClientEvent and FoodVendorBuyToInventoryClientEvent.new then
				clientEvent = FoodVendorBuyToInventoryClientEvent.new(payload)
			end

			if clientEvent ~= nil then
				if g_server ~= nil and connection ~= nil then
					connection:sendEvent(clientEvent)
				elseif clientEvent.run then
					clientEvent:run(nil)
				end
			end
		end
	end
end

-- =======================
if _G.PCC_TakeToInventoryEvent == nil then
    PCC_TakeToInventoryEvent = {}
    local mt = Class(PCC_TakeToInventoryEvent, Event)
    InitEventClass(PCC_TakeToInventoryEvent, "PCC_TakeToInventoryEvent")

    function PCC_TakeToInventoryEvent.emptyNew() return Event.new(mt) end
    function PCC_TakeToInventoryEvent.new(placeable, recipeIndex)
        local self = PCC_TakeToInventoryEvent.emptyNew()
        self.placeable   = placeable
        self.recipeIndex = recipeIndex or 0
        return self
    end

    function PCC_TakeToInventoryEvent:writeStream(streamId, connection)
        NetworkUtil.writeNodeObject(streamId, self.placeable)
        streamWriteUInt16(streamId, self.recipeIndex or 0)
    end

    function PCC_TakeToInventoryEvent:readStream(streamId, connection)
        self.placeable   = NetworkUtil.readNodeObject(streamId)
        self.recipeIndex = streamReadUInt16(streamId)
        self:run(connection)
    end

	function PCC_TakeToInventoryEvent:run(connection)
		if g_server ~= nil and self.placeable and self.placeable.pcServerTakeToInventory then
			local farmId = 1
			if HungerSystem and HungerSystem.getFarmIdFromConnection then
				farmId = HungerSystem.getFarmIdFromConnection(connection)
			elseif g_currentMission and g_currentMission.player then
				farmId = g_currentMission.player.farmId or 1
			end

			local ok, payload = self.placeable:pcServerTakeToInventory(farmId, self.recipeIndex)
			if not ok then
				return
			end

			PCC_StateSyncEvent.send(self.placeable)

			local clientEvent
			if FoodVendorBuyToInventoryClientEvent and FoodVendorBuyToInventoryClientEvent.new then
				clientEvent = FoodVendorBuyToInventoryClientEvent.new(payload)
			end

			if clientEvent ~= nil then
				if g_server ~= nil and connection ~= nil then
					connection:sendEvent(clientEvent)
				elseif clientEvent.run then
					clientEvent:run(nil)
				end
			end
		end
	end

end

-- =======================
if _G.PCC_AddInventoryClientEvent == nil then
    PCC_AddInventoryClientEvent = {}
    local mt = Class(PCC_AddInventoryClientEvent, Event)
    InitEventClass(PCC_AddInventoryClientEvent, "PCC_AddInventoryClientEvent")
    function PCC_AddInventoryClientEvent.emptyNew() return Event.new(mt) end
    function PCC_AddInventoryClientEvent.new(payload) local self=PCC_AddInventoryClientEvent.emptyNew(); self.payload=payload or {}; return self end
    function PCC_AddInventoryClientEvent:writeStream(streamId, connection)
        local p = self.payload or {}
        streamWriteString(streamId, tostring(p.name or "Food"))
        streamWriteString(streamId, tostring(p.icon or ""))
        streamWriteInt8 (streamId, Utils.clamp(p.hungerGain or 0, -100, 100))
        streamWriteInt8 (streamId, Utils.clamp(p.vigorGain  or 0, -100, 100))
        streamWriteString(streamId, tostring((p.kind=="effect") and "effect" or "food"))
        streamWriteString(streamId, tostring(p.effectId or ""))
        streamWriteString(streamId, tostring(p.effectsFile or ""))
    end
    function PCC_AddInventoryClientEvent:readStream(streamId, connection)
        local p = {}
        p.name       = streamReadString(streamId)
        p.icon       = streamReadString(streamId)
        p.hungerGain = streamReadInt8(streamId)
        p.vigorGain  = streamReadInt8(streamId)
        p.kind       = streamReadString(streamId)
        p.effectId   = streamReadString(streamId)
        p.effectsFile= streamReadString(streamId)
        self.payload = p
        self:run(connection)
    end
    function PCC_AddInventoryClientEvent:run(connection)
        if _G.FoodVendorHUD and FoodVendorHUD._addPayloadToInventory then
            FoodVendorHUD._addPayloadToInventory(self.payload or {})
        elseif _G.Inventory and Inventory.API and Inventory.API.addItemInstance then
            Inventory.API.addItemInstance({
                name  = self.payload.name,
                icon  = self.payload.icon,
                kind  = self.payload.kind,
                hungerGain = self.payload.hungerGain,
                vigorGain  = self.payload.vigorGain,
                effectId   = self.payload.effectId,
                effectsFile= self.payload.effectsFile
            })
        end
    end
end

-- =======================
if _G.PCC_DiscardEvent == nil then
    PCC_DiscardEvent = {}
    local mt = Class(PCC_DiscardEvent, Event)
    InitEventClass(PCC_DiscardEvent, "PCC_DiscardEvent")
    function PCC_DiscardEvent.emptyNew() return Event.new(mt) end
    function PCC_DiscardEvent.new(placeable) local self=PCC_DiscardEvent.emptyNew(); self.placeable=placeable; return self end
    function PCC_DiscardEvent:writeStream(streamId, connection) NetworkUtil.writeNodeObject(streamId, self.placeable) end
    function PCC_DiscardEvent:readStream(streamId, connection)  self.placeable=NetworkUtil.readNodeObject(streamId); self:run(connection) end
	function PCC_DiscardEvent:run(connection)
		if g_server ~= nil and self.placeable and self.placeable.pcServerDiscardCooked then
			local farmId = 1
			if HungerSystem and HungerSystem.getFarmIdFromConnection then
				farmId = HungerSystem.getFarmIdFromConnection(connection)
			elseif g_currentMission and g_currentMission.player then
				farmId = g_currentMission.player.farmId or 1
			end

			self.placeable:pcServerDiscardCooked(farmId)
			PCC_StateSyncEvent.send(self.placeable)
		end
	end
end
