-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 11.11.2025

if PlayerCamera == nil then
    print("[DrunkCam] PlayerCamera not available")
    return
end

local TWO_PI = math.pi * 2.0
local function timeSec() return (g_time or 0) * 0.001 end
local function clamp(v, a, b) if v < a then return a elseif v > b then return v else return v end end

local function getActiveCameraNode(self)
    if self.isFirstPerson then
        if self.cameraNode and self.cameraNode ~= 0 then return self.cameraNode end
        if self.firstPersonNode and self.firstPersonNode ~= 0 then return self.firstPersonNode end
    end
    return self.cameraRootNode
end

local function captureBaseTransform(self, node)
    local bx, by, bz = getTranslation(node)
    local brx, bry, brz = getRotation(node)
    self.__drunkBasePos  = {bx or 0, by or 0, bz or 0}
    self.__drunkBaseRot  = {brx or 0, bry or 0, brz or 0}
end

-------------------------------------------------------------------------------
-- РАСШИРЕННЫЙ API КАМЕРЫ
-------------------------------------------------------------------------------
function PlayerCamera:setExternalShakeProvider(fn)
    self.__externalShakeProvider = fn
end

function PlayerCamera:setDrunkSwayEx(enabled, cfg)
    if enabled then
        cfg = cfg or {}
        self.__drunkCfg = {
            ampX  = cfg.ampX or 0.012,      ampY  = cfg.ampY or 0.006,  ampZ = cfg.ampZ or 0.0,
            rollAmp = cfg.rollAmp or 0.01,  period = math.max(0.2, cfg.period or 2.8),

            phaseX = cfg.phaseX or 0.0,     phaseY = cfg.phaseY or (math.pi * 0.5),
            phaseZ = cfg.phaseZ or 0.0,     phaseRoll = cfg.phaseRoll or (math.pi * 0.33),

            noiseAmp = cfg.noiseAmp or 0.0, noisePeriod = math.max(0.2, cfg.noisePeriod or 2.4),

            fpScale = cfg.fpScale or 1.0,   tpScale = cfg.tpScale or 0.45,
            fpOnly  = cfg.fpOnly or false,  tpOnly  = cfg.tpOnly or false,

            fadeInSec  = math.max(0.0, tonumber(cfg.fadeInSec  or 0) or 0),
            fadeOutSec = math.max(0.0, tonumber(cfg.fadeOutSec or 0) or 0),

            startAtMs  = tonumber(cfg.startAtMs or 0) or 0,
            untilMs    = tonumber(cfg.untilMs   or 0) or 0
        }

        self:setExternalShakeProvider(function(dt)
            local C = self.__drunkCfg ; if not C then return 0,0,0,0 end

            local fp = self.isFirstPerson
            if (C.fpOnly and not fp) or (C.tpOnly and fp) then return 0,0,0,0 end

            local k = fp and (C.fpScale or 1) or (C.tpScale or 0.45)

            local nowMs = (rawget(_G, "g_ItemEffectsNowMs") or g_time or 0)

            local kin, kout = 1.0, 1.0
            if (C.startAtMs or 0) > 0 and (C.fadeInSec or 0) > 0 then
                local sinceStart = math.max(0, nowMs - (C.startAtMs or 0)) / 1000.0
                kin = math.min(1.0, sinceStart / (C.fadeInSec or 0.001))
            end
            if (C.untilMs or 0) > 0 and (C.fadeOutSec or 0) > 0 then
                local remain = math.max(0, (C.untilMs or 0) - nowMs) / 1000.0
                kout = math.min(1.0, remain / (C.fadeOutSec or 0.001))
            end
            local fade = math.min(kin, kout)
            if fade <= 0.0001 then return 0,0,0,0 end

            local t = nowMs * 0.001
            local w = (math.pi * 2.0) / (C.period or 2.8)

            local x = math.sin(t*w + (C.phaseX or 0)) * (C.ampX or 0)
            local y = math.sin(t*w + (C.phaseY or 0)) * (C.ampY or 0)
            local z = math.sin(t*w + (C.phaseZ or 0)) * (C.ampZ or 0)
            local r = math.sin(t*w + (C.phaseRoll or 0)) * (C.rollAmp or 0)

            local nAmp = C.noiseAmp or 0
            if nAmp > 0 then
                local wn = (math.pi * 2.0) / (C.noisePeriod or 2.4)
                x = x + (math.sin(t*wn*0.83 + 0.7) * nAmp)
                y = y + (math.sin(t*wn*1.12 + 1.3) * nAmp * 0.7)
            end

            local kk = k * fade
            return x*kk, y*kk, z*kk, r*kk
        end)
    else
        self.__drunkCfg = nil
        self:setExternalShakeProvider(nil)
    end
end

if PlayerCamera.setDrunkFovEx == nil then
    function PlayerCamera:setDrunkFovEx(enable, cfg)
    end
end

if not PlayerCamera.__drunkNoFovPatched then
    PlayerCamera.__drunkNoFovPatched = true

    local __orig_tryApplyViewBobbing = PlayerCamera.tryApplyViewBobbing
    PlayerCamera.tryApplyViewBobbing = function(self, dt)
        __orig_tryApplyViewBobbing(self, dt)

        local node = getActiveCameraNode(self)
        if node == nil or node == 0 then node = self.cameraRootNode end
        if not node or node == 0 then return end

        if not self.__drunkBasePos or not self.__drunkBaseRot then
            captureBaseTransform(self, node)
        else
            captureBaseTransform(self, node)
        end

        local dx, dy, dz, dRoll = 0,0,0,0
        if self.__externalShakeProvider then
            local ok, x, y, z, r = pcall(self.__externalShakeProvider, dt or 0)
            if ok and x then dx, dy, dz, dRoll = x, y or 0, z or 0, r or 0 end
        end

        if dx ~= 0 or dy ~= 0 or (dz or 0) ~= 0 or (dRoll or 0) ~= 0 then
            local bx, by, bz = self.__drunkBasePos[1], self.__drunkBasePos[2], self.__drunkBasePos[3]
            setTranslation(node, bx + dx, by + dy, bz + (dz or 0))
            local rx, ry, _  = getRotation(node)
            local baseRoll   = self.__drunkBaseRot[3] or 0
            setRotation(node, rx, ry, baseRoll + (dRoll or 0))
        end
    end
end

g_DrunkPlayerWobble = {
    enabled   = false,
    ampStrafe = 0.012, -- влево/вправо
    ampForward= 0.0,   -- вперёд/назад
    period    = 2.8,
    smoothMs  = 120.0,
    groundOnly= true,
    fpOnly    = true,  -- только в 1-м лице
    tpOnly    = false,
    _vx = 0.0, _vz = 0.0
}

local function applyPlayerWobble(player, dt)
    local W = g_DrunkPlayerWobble
    if not W or not W.enabled then return end
    if player.getIsInVehicle and player:getIsInVehicle() then return end
    if W.groundOnly and (not player.mover or not player.mover.isGrounded) then return end
    local fp = player.camera and player.camera.isFirstPerson
    if (W.fpOnly and not fp) or (W.tpOnly and fp) then return end

    local t = timeSec()
    local per = math.max(0.2, W.period or 2.8)

    -- синус по осям: strafe (лево/право) и forward (вперёд/назад)
    local sx = math.sin(t * TWO_PI / per) * (W.ampStrafe or 0.0)
    local sz = math.cos(t * TWO_PI / per) * (W.ampForward or 0.0)

    -- сглаживание
    local alpha = clamp((dt or 16.6) / (W.smoothMs or 120.0), 0.01, 1.0)
    W._vx = W._vx + (sx - W._vx) * alpha
    W._vz = W._vz + (sz - W._vz) * alpha

    local yaw = 0
    local camNode = player and player.camera and getActiveCameraNode(player.camera) or nil
    if camNode and camNode ~= 0 then
        local _, y, _ = getRotation(camNode); yaw = y or 0
    end

    local cosY, sinY = math.cos(yaw), math.sin(yaw)
    local fwdX,   fwdZ   =  cosY, sinY
    local rightX, rightZ = -sinY, cosY

    local worldDX = rightX * W._vx + fwdX * W._vz   -- X
    local worldDZ = rightZ * W._vx + fwdZ * W._vz   -- Z

    local k = (dt or 16.6) / 16.6
    if player.moveCCTExternal then
        player:moveCCTExternal(worldDX * k, 0, worldDZ * k)
    end
end

if Player and not Player.__drunkWobblePatched_NoFov then
    Player.__drunkWobblePatched_NoFov = true
    local __orig_update = Player.update
    Player.update = function(self, dt)
        __orig_update(self, dt)
        if self.isOwner and self.camera then
            applyPlayerWobble(self, dt or 16.6)
        end
    end
end
