-- Мод для добавления пользовательских категорий и вкладок в меню строительства
-- Автор: BMP

loadConstructionCategories = {}

local modDir = g_currentModDirectory
local modName = g_currentModName

function loadConstructionCategories.loadMapData(self, superFunc, xmlFile, missionInfo, baseDirectory)
    superFunc(self, xmlFile, missionInfo, baseDirectory)

    local xmlFile = XMLFile.load("ModFile", modDir .. "modDesc.xml")
    if not xmlFile then
        Logging.warning("Failed to load modDesc.xml")
        return true
    end

    for _, key in xmlFile:iterator("modDesc.constructionCategories.constructionType") do
        local categoryName = xmlFile:getString(key .. "#name")
        local title = g_i18n:convertText(xmlFile:getString(key .. "#title"), modName)
        local iconFilename = xmlFile:getString(key .. "#iconFilename")
        local refSize = xmlFile:getVector(key .. "#refSize", {256, 256}, 2)
        local iconUVs = GuiUtils.getUVs(xmlFile:getString(key .. "#iconUVs", "0 0 1 1"), refSize)
        local iconSliceId = xmlFile:getString(key .. "#iconSliceId")

        if categoryName and title and iconFilename then
            Logging.info("Adding construction category: %s, title: %s", categoryName, title)
            g_storeManager:addConstructionCategory(categoryName, title, iconFilename, iconUVs, modDir, iconSliceId)
        else
            Logging.warning("Invalid constructionType: name=%s, title=%s, iconFilename=%s", tostring(categoryName), tostring(title), tostring(iconFilename))
        end
    end

    for _, key in xmlFile:iterator("modDesc.constructionCategories.constructionCategory") do
        local categoryTypeName = xmlFile:getString(key .. "#type")
        local tabName = xmlFile:getString(key .. "#name")
        local tabTitle = g_i18n:convertText(xmlFile:getString(key .. "#title"), modName)

        if categoryTypeName and tabName and tabTitle then
            Logging.info("Adding construction tab: %s, title: %s", tabName, tabTitle)
            g_storeManager:addConstructionTab(categoryTypeName, tabName, tabTitle, nil, nil, modDir, nil)
        else
            Logging.warning("Invalid constructionCategory: type=%s, name=%s, title=%s", tostring(categoryTypeName), tostring(tabName), tostring(tabTitle))
        end
    end

    xmlFile:delete()

    return true
end

StoreManager.loadMapData = Utils.overwrittenFunction(StoreManager.loadMapData, loadConstructionCategories.loadMapData)