-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 15.11.2025

PlaceableVisibilityToggle = {
    prerequisitesPresent = function(specializations)
        return true
    end
}

function PlaceableVisibilityToggle.registerFunctions(placeableType)
    SpecializationUtil.registerFunction(placeableType, "toggleVisibilityNode", PlaceableVisibilityToggle.toggleVisibilityNode)
end

function PlaceableVisibilityToggle.registerEventListeners(placeableType)
    SpecializationUtil.registerEventListener(placeableType, "onLoad", PlaceableVisibilityToggle)
    SpecializationUtil.registerEventListener(placeableType, "onFinalizePlacement", PlaceableVisibilityToggle)
end

function PlaceableVisibilityToggle.registerXMLPaths(schema, basePath)
    schema:setXMLSpecializationType("visibilityToggle")
    basePath = basePath .. ".visibilityToggle"
    schema:register(XMLValueType.NODE_INDEX, basePath .. "#visibilityNode", "Node to show before placement")
    schema:setXMLSpecializationType()
end

function PlaceableVisibilityToggle:onLoad(savegame)
    self.spec_visibilityToggle = {
        visibilityNode = nil
    }
    local spec = self.spec_visibilityToggle
    local key = "placeable.visibilityToggle"

    -- Загружаем ноду из XML
    spec.visibilityNode = self.xmlFile:getValue(key .. "#visibilityNode", nil, self.components, self.i3dMappings)

    if spec.visibilityNode == nil then
        Logging.xmlWarning(self.xmlFile, "Missing visibilityNode for visibilityToggle")
        return
    end

    -- Показываем ноду при загрузке (до размещения)
    setVisibility(spec.visibilityNode, true)
end

function PlaceableVisibilityToggle:onFinalizePlacement()
    local spec = self.spec_visibilityToggle
    if spec == nil or spec.visibilityNode == nil then return end

    -- Скрываем ноду после финального размещения
    setVisibility(spec.visibilityNode, false)
end

function PlaceableVisibilityToggle:toggleVisibilityNode(visible)
    local spec = self.spec_visibilityToggle
    if spec == nil or spec.visibilityNode == nil then return end

    setVisibility(spec.visibilityNode, visible)
end