-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 11.11.2025

PlaceableIngredientShop = {}
PlaceableIngredientShop.modDirectory = g_currentModDirectory or ""

------------------------- локалки/утилиты -------------------------
local function _l10n(raw)
    if not raw or raw=="" then return "" end
    if raw:sub(1,1)~="$" then return raw end
    local k=raw:sub(2)
    if g_i18n and g_i18n:hasText(k) then
        return g_i18n:getText(k)
    end
    if k:sub(1,5)=="l10n_" and g_i18n:hasText(k:sub(6)) then
        return g_i18n:getText(k:sub(6))
    end
    return k
end

local function _isLocalPlayerActor(otherId)
    if not otherId or otherId==0 or not g_localPlayer then return false end
    if otherId == g_localPlayer.rootNode or otherId == g_localPlayer.playerNode then
        return true
    end
    local parent = getParent(otherId)
    while parent ~= 0 do
        if parent == g_localPlayer.rootNode then
            return true
        end
        parent = getParent(parent)
    end
    return false
end

------------------------- Activatable -------------------------
PIS_Activatable = {}
local PIS_Activatable_mt = Class(PIS_Activatable)

function PIS_Activatable.new(placeable)
    local self = setmetatable({}, PIS_Activatable_mt)
    self.placeable    = placeable
    self.activateText = (g_i18n and g_i18n:getText("ui_pis_openHint")) or "Открыть магазин (R)"
    return self
end

function PIS_Activatable:getIsActivatable()
    if g_localPlayer == nil then return false end
    if g_localPlayer.getIsInVehicle and g_localPlayer:getIsInVehicle() then return false end
    return self.placeable ~= nil
end

function PIS_Activatable:run()
    if not g_gui then return end

    if not (g_gui.guis and g_gui.guis["IngredientShopHUD"]) then
        if IngredientShopHUD and IngredientShopHUD.register then
            IngredientShopHUD.register()
        else
            print("[PIS] IngredientShopHUD module not found")
            return
        end
    end

    local guiDef = g_gui.guis and g_gui.guis["IngredientShopHUD"]
    if guiDef and guiDef.target then
        guiDef.target.placeable = self.placeable
    end

    g_gui:showDialog("IngredientShopHUD")
end

------------------------- GUI open -------------------------
function PlaceableIngredientShop:pisOpenGUI()
    if not g_gui then return end

    if IngredientShopHUD and IngredientShopHUD.register then
        IngredientShopHUD.register()
    end

    local guiDef = g_gui.guis and g_gui.guis["IngredientShopHUD"]
    if not guiDef then return end

    local inst = guiDef.target
    if inst then
        inst.placeable = self
        g_gui:showGui("IngredientShopHUD")
        if inst.pullData then
            inst:pullData()
        end
    end
end

------------------------- регистрация спец. -------------------------
function PlaceableIngredientShop.prerequisitesPresent(s)
    return true
end

function PlaceableIngredientShop.registerEventListeners(t)
    SpecializationUtil.registerEventListener(t, "onLoad",  PlaceableIngredientShop)
    SpecializationUtil.registerEventListener(t, "onDelete",PlaceableIngredientShop)
end

function PlaceableIngredientShop.registerXMLPaths(schema, basePath)
    schema:register(XMLValueType.STRING,     basePath..".ingredientShop#title",       "Title")
    schema:register(XMLValueType.NODE_INDEX, basePath..".ingredientShop#triggerNode", "Trigger")

    local it = basePath..".ingredientShop.items.item(?)"
    schema:register(XMLValueType.STRING, it.."#name",  "Name")
    schema:register(XMLValueType.STRING, it.."#icon",  "Icon")
    schema:register(XMLValueType.STRING, it.."#desc",  "Desc")
    schema:register(XMLValueType.STRING, it.."#id",    "Inventory id")
    schema:register(XMLValueType.INT,    it.."#pack",  "Count per purchase", 1)
    schema:register(XMLValueType.INT,    it.."#price", "Price", 10)
end

function PlaceableIngredientShop.registerFunctions(placeableType)
    SpecializationUtil.registerFunction(placeableType, "pisTriggerCallback", PlaceableIngredientShop.pisTriggerCallback)
    SpecializationUtil.registerFunction(placeableType, "buyServer",          PlaceableIngredientShop.buyServer)
end

------------------------- onLoad/onDelete -------------------------
function PlaceableIngredientShop:onLoad(savegame)
    self.spec_ingredientShop = self.spec_ingredientShop or {}
    local spec = self.spec_ingredientShop
    local xml  = self.xmlFile

    local ttl = xml:getValue("placeable.ingredientShop#title") or "$ui_pis_title"
    if ttl:sub(1,1)=="$" and g_i18n and g_i18n:hasText(ttl:sub(2)) then
        spec.title = g_i18n:getText(ttl:sub(2))
    else
        spec.title = ttl
    end

    spec.triggerNode = xml:getValue("placeable.ingredientShop#triggerNode", nil, self.components, self.i3dMappings)
    if spec.triggerNode ~= nil then
        addTrigger(spec.triggerNode, "pisTriggerCallback", self)
    else
        Logging.xmlWarning(self.xmlFile, "[PIS] Missing trigger node 'placeable.ingredientShop#triggerNode'")
    end

    -- ассортимент
    spec.items = {}
    local i = 0
    while true do
        local key = ("placeable.ingredientShop.items.item(%d)"):format(i)
        if not xml:hasProperty(key) then break end

        local name = xml:getValue(key.."#name") or ("Item "..(i+1))
        if name:sub(1,1)=="$" and g_i18n and g_i18n:hasText(name:sub(2)) then
            name = g_i18n:getText(name:sub(2))
        end

        ----------------------------------------------------------------
        -- ИКОНКА: храним одновременно относительный и абсолютный путь
        ----------------------------------------------------------------
        local iconRel = xml:getValue(key.."#icon") or ""
        local iconAbs = nil
        if iconRel ~= "" then
            iconAbs = Utils.getFilename(iconRel, PlaceableIngredientShop.modDirectory)
            if iconAbs and not fileExists(iconAbs) then
                iconAbs = nil
            end
        end

        local desc  = xml:getValue(key.."#desc")
        local id    = xml:getValue(key.."#id")
        local pack  = math.max(1, xml:getValue(key.."#pack", 1))
        local price = math.max(0, xml:getValue(key.."#price", 0))

        table.insert(spec.items, {
            index   = i+1,
            name    = name,
            icon    = iconAbs,   -- для локального HUD
            iconRel = iconRel,   -- для отправки по сети клиенту
            desc    = desc,
            id      = id,
            pack    = pack,
            price   = price
        })

        i = i + 1
    end

    if not self.pisActivatable then
        self.pisActivatable = PIS_Activatable.new(self)
        self.pisActivatable.activateText = string.format(
            "%s: %s",
            (g_i18n and g_i18n:getText("ui_pis_openHint")) or "Открыть магазин (R)",
            spec.title or ""
        )
    end

    if g_gui and (not (g_gui.guis and g_gui.guis["IngredientShopHUD"])) then
        if IngredientShopHUD and IngredientShopHUD.register then
            IngredientShopHUD.register()
        end
    end
end


function PlaceableIngredientShop:onDelete()
    local spec = self.spec_ingredientShop
    if spec and spec.triggerNode then
        removeTrigger(spec.triggerNode)
        spec.triggerNode = nil
    end
    if self.pisActivatable then
        g_currentMission.activatableObjectsSystem:removeActivatable(self.pisActivatable)
        self.pisActivatable = nil
    end
end

------------------------- покупка (server) -------------------------
-- ВАЖНО:
--  * Сервер только проверяет деньги и формирует payload.
--  * Инвентарь трогается ТОЛЬКО на клиенте через PIS_BuyToInventoryClientEvent.
-- ВАЖНО:
--  * Сервер только проверяет деньги и формирует payload.
--  * Инвентарь трогается ТОЛЬКО на клиенте через PIS_BuyToInventoryClientEvent.
function PlaceableIngredientShop:buyServer(idx, farmId)
    local spec = self.spec_ingredientShop
    if not spec then
        return false, "noSpec"
    end

    local it = spec.items[idx]
    if not it then
        return false, "noItem"
    end

    local price = math.max(0, it.price or 0)
    local buyerFarmId = farmId or (g_currentMission and g_currentMission:getFarmId()) or 1
    local farm = g_farmManager and g_farmManager:getFarmById(buyerFarmId)

    if price > 0 then
        if not farm or (farm.money or 0) < price then
            return false, "noMoney"
        end

        if g_currentMission and g_currentMission.addMoney then
            g_currentMission:addMoney(-price, buyerFarmId, MoneyType.OTHER or 0, true, true)
        elseif farm and farm.changeBalance then
            farm:changeBalance(-price, { statistic = (FinanceStats and FinanceStats.CHANGE_SHOP_PURCHASE) or nil })
        end
    end

    local pack = math.max(1, it.pack or 1)

    ----------------------------------------------------------------
    -- В payload отправляем ОТНОСИТЕЛЬНЫЙ путь к иконке (iconRel),
    -- чтобы клиент сам собрал корректный абсолютный путь у себя.
    ----------------------------------------------------------------
    local payload = {
        id   = it.id,
        name = it.name,
        desc = it.desc,
        icon = it.iconRel or "",   -- <<< ВАЖНО: относительный путь!
        kind = "ingredient",
        pack = pack
    }

    return true, payload
end

------------------------- Trigger callback -------------------------
function PlaceableIngredientShop:pisTriggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
    if not (onEnter or onLeave) then return end
    if g_localPlayer == nil then return end
    if otherActorId ~= g_localPlayer.rootNode then return end

    if onEnter then
        if Platform.gameplay and Platform.gameplay.autoActivateTrigger and self.pisActivatable:getIsActivatable() then
            self.pisActivatable:run()
        else
            g_currentMission.activatableObjectsSystem:addActivatable(self.pisActivatable)
        end
    end

    if onLeave then
        g_currentMission.activatableObjectsSystem:removeActivatable(self.pisActivatable)
    end
end
