-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 11.11.2025

PIS_BuyEvent = {}
local PIS_BuyEvent_mt = Class(PIS_BuyEvent, Event)

InitEventClass(PIS_BuyEvent, "PIS_BuyEvent")

function PIS_BuyEvent.emptyNew()
    return Event.new(PIS_BuyEvent_mt)
end

function PIS_BuyEvent.new(placeable, itemIndex)
    local self = PIS_BuyEvent.emptyNew()
    self.placeable = placeable
    self.itemIndex = math.max(1, itemIndex or 1)
    return self
end

function PIS_BuyEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
    streamWriteUInt16(streamId, self.itemIndex or 1)
end

function PIS_BuyEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)
    self.itemIndex = streamReadUInt16(streamId)
    self:run(connection)
end

function PIS_BuyEvent:run(connection)
    -- Этот ивент должен ОБРАБАТЫВАТЬСЯ ТОЛЬКО НА СЕРВЕРЕ как запрос от клиента
    if g_server == nil then
        return
    end

    if not self.placeable or not self.placeable.buyServer then
        return
    end

    -- Определяем ферму покупателя по соединению
    local farmId = 1
    if HungerSystem and HungerSystem.getFarmIdFromConnection then
        farmId = HungerSystem.getFarmIdFromConnection(connection)
    elseif g_currentMission and g_currentMission.getFarmId then
        farmId = g_currentMission:getFarmId() or 1
    end

    local ok, result = self.placeable:buyServer(self.itemIndex, farmId)

    if not ok then
        -- Сервер знает причину, но UI есть только у клиента.
        -- Для хоста (listen-server) g_currentMission есть, для дедика — нет, но там и UI нет.
        if g_currentMission then
            if result == "noMoney" then
                g_currentMission:showBlinkingWarning(
                    g_i18n:getText("ui_pis_nomoney") or "Недостаточно денег",
                    3000
                )
            elseif result == "noSpace" then
                g_currentMission:showBlinkingWarning(
                    g_i18n:getText("ui_pis_noSpace") or "Нет места в инвентаре",
                    3000
                )
            end
        end
        return
    end

    -- Успех: result — это payload с данными предметов
    if connection ~= nil then
        PIS_BuyToInventoryClientEvent.sendToConnection(connection, result or {})
    end
end

----------------------------------------------------------------
-- Клиентский ивент: добавляет купленные ингредиенты в Inventory
----------------------------------------------------------------
PIS_BuyToInventoryClientEvent = {}
local PIS_BuyToInventoryClientEvent_mt = Class(PIS_BuyToInventoryClientEvent, Event)
InitEventClass(PIS_BuyToInventoryClientEvent, "PIS_BuyToInventoryClientEvent")

function PIS_BuyToInventoryClientEvent.emptyNew()
    return Event.new(PIS_BuyToInventoryClientEvent_mt)
end

function PIS_BuyToInventoryClientEvent.new(payload)
    local self = PIS_BuyToInventoryClientEvent.emptyNew()
    self.payload = payload or {}
    return self
end

function PIS_BuyToInventoryClientEvent:writeStream(streamId, connection)
    local p = self.payload or {}
    streamWriteString(streamId, tostring(p.name or "Ingredient"))
    streamWriteString(streamId, tostring(p.desc or ""))
    streamWriteString(streamId, tostring(p.icon or ""))
    streamWriteString(streamId, tostring(p.kind or "ingredient"))
    streamWriteString(streamId, tostring(p.id   or ""))
    streamWriteUInt8(streamId, math.max(1, p.pack or 1))
end

function PIS_BuyToInventoryClientEvent:readStream(streamId, connection)
    local p = {}
    p.name = streamReadString(streamId)
    p.desc = streamReadString(streamId)
    p.icon = streamReadString(streamId)
    p.kind = streamReadString(streamId)
    p.id   = streamReadString(streamId)
    p.pack = streamReadUInt8(streamId)
    self.payload = p
    self:run(connection)
end

function PIS_BuyToInventoryClientEvent:run(connection)
    if not _G.Inventory or not Inventory.API or not Inventory.API.addItemInstance then
        print("[PIS] Inventory API not found on client")
        return
    end

    local p = self.payload or {}
    local pack = math.max(1, p.pack or 1)

    ------------------------------------------------------------
    -- НОРМАЛИЗУЕМ ИКОНКУ НА КЛИЕНТЕ
    -- с сервера пришёл относительный путь (gui/ing/xxx.dds и т.п.)
    ------------------------------------------------------------
    local iconRel = p.icon or ""
    local iconAbs = iconRel

    if iconRel ~= "" then
        -- 1) Пробуем через мод-папку инвентаря (там у тебя обычно LiveFarmer)
        if Inventory and Inventory.modDir then
            local candidate = Utils.getFilename(iconRel, Inventory.modDir)
            if candidate and fileExists(candidate) then
                iconAbs = candidate
            end
        end

        -- 2) Если не нашли — пробуем папку магазина ингредиентов
        if (iconAbs == iconRel or not fileExists(iconAbs))
        and PlaceableIngredientShop and PlaceableIngredientShop.modDirectory then
            local candidate = Utils.getFilename(iconRel, PlaceableIngredientShop.modDirectory)
            if candidate and fileExists(candidate) then
                iconAbs = candidate
            end
        end

        -- 3) Крайний фоллбек: текущая мод-папка (на всякий случай)
        if (iconAbs == iconRel or not fileExists(iconAbs)) and g_currentModDirectory then
            local candidate = Utils.getFilename(iconRel, g_currentModDirectory)
            if candidate and fileExists(candidate) then
                iconAbs = candidate
            end
        end
    end

    for n = 1, pack do
        local ok, reason = Inventory.API.addItemInstance({
            id   = p.id,
            name = p.name,
            desc = p.desc,
            icon = iconAbs or "",
            kind = p.kind or "ingredient",
            hungerGain = 0,
            vigorGain  = 0,
        })
        if not ok then
            -- место кончилось уже на клиенте
            if g_currentMission then
                g_currentMission:showBlinkingWarning(
                    g_i18n:getText("ui_pis_noSpace") or "Нет места в инвентаре",
                    3000
                )
            end
            break
        end
    end
end


function PIS_BuyToInventoryClientEvent.sendToConnection(connection, payload)
    if connection ~= nil then
        connection:sendEvent(PIS_BuyToInventoryClientEvent.new(payload))
    end
end

-- Возможность использовать и старый helper, если где-то вызывался
function PIS_BuyEvent.send(placeable, itemIndex)
    if g_server ~= nil then
        g_server:broadcastEvent(PIS_BuyEvent.new(placeable, itemIndex), nil, nil, placeable)
    else
        g_client:getServerConnection():sendEvent(PIS_BuyEvent.new(placeable, itemIndex))
    end
end
