-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 11.11.2025

IngredientShopHUD = {}
local IngredientShopHUD_mt = Class(IngredientShopHUD, MessageDialog)

local function _l10n(s)
    if not s or s == "" then return "" end
    if s:sub(1,1) ~= "$" then return s end
    local k = s:sub(2)
    if g_i18n and g_i18n:hasText(k) then return g_i18n:getText(k) end
    if k:sub(1,5) == "l10n_" and g_i18n and g_i18n:hasText(k:sub(6)) then
        return g_i18n:getText(k:sub(6))
    end
    return s
end

local function _getLiveFarmerBaseDir_PIS()
    local candidates = {}

    if PlaceableIngredientShop and PlaceableIngredientShop.modDirectory and PlaceableIngredientShop.modDirectory ~= "" then
        table.insert(candidates, PlaceableIngredientShop.modDirectory)
    end
    if IngredientShopHUD.modDirectory and IngredientShopHUD.modDirectory ~= "" then
        table.insert(candidates, IngredientShopHUD.modDirectory)
    end

    if g_modManager ~= nil then
        if g_modManager.getModByName ~= nil then
            local m = g_modManager:getModByName("FS25_liveFarmer")
            if m ~= nil then
                local dir = m.modDir or m.modDirectory or m.absolutePath or m.path or m.directory
                if dir and dir ~= "" then
                    table.insert(candidates, dir)
                end
            end
        end

        if g_modManager.mods ~= nil then
            for _, m in pairs(g_modManager.mods) do
                local name     = m.modName or m.name or ""
                local fileName = m.modFileName or ""
                if name == "FS25_liveFarmer" or fileName:lower():find("fs25_livefarmer") ~= nil then
                    local dir = m.modDir or m.modDirectory or m.absolutePath or m.path or m.directory
                    if dir and dir ~= "" then
                        table.insert(candidates, dir)
                    end
                end
            end
        end
    end

    if debug and debug.getinfo then
        local info = debug.getinfo(_getLiveFarmerBaseDir_PIS, "S")
        if info and info.source then
            local src = info.source
            if src:sub(1,1) == "@" then src = src:sub(2) end
            src = src:gsub("\\", "/")
            local idx = src:lower():find("/fs25_livefarmer/")
            if idx then
                local dir = src:sub(1, idx + string.len("/FS25_liveFarmer/") - 1)
                table.insert(candidates, dir)
            end
        end
    end

    if g_modsDirectory ~= nil then
        table.insert(candidates, g_modsDirectory .. "/FS25_liveFarmer/")
    end

    local tried = {}
    for _, baseDir in ipairs(candidates) do
        if type(baseDir) == "string" and baseDir ~= "" then
            baseDir = baseDir:gsub("\\", "/")
            if baseDir:sub(-1) ~= "/" then
                baseDir = baseDir .. "/"
            end
            if not tried[baseDir] then
                tried[baseDir] = true
                local testPath = Utils.getFilename("gui/IngredientShopHUD.xml", baseDir)
                if testPath and fileExists(testPath) then
                    return baseDir
                end
            end
        end
    end

    return IngredientShopHUD.modDirectory or (g_currentModDirectory or "")
end

function IngredientShopHUD.register()
    if not g_gui then return false end

    if g_gui.guis and g_gui.guis["IngredientShopHUD"] then
        IngredientShopHUD.INSTANCE = g_gui.guis["IngredientShopHUD"].target
        return true
    end

    local inst = IngredientShopHUD.new()

    local baseDir = _getLiveFarmerBaseDir_PIS()
    baseDir = baseDir or ""
    baseDir = baseDir:gsub("\\", "/")
    if baseDir ~= "" and baseDir:sub(-1) ~= "/" then
        baseDir = baseDir .. "/"
    end

    local xmlPath = Utils.getFilename("gui/IngredientShopHUD.xml", baseDir)
    local ok = false

    if xmlPath and xmlPath ~= "" then
        ok = pcall(function()
            g_gui:loadGui(xmlPath, "IngredientShopHUD", inst)
        end)
    end

    if (not ok) or not (g_gui.guis and g_gui.guis["IngredientShopHUD"]) then
        local path1 = baseDir .. "gui/IngredientShopHUD.xml"
        local path2 = baseDir .. "IngredientShopHUD.xml"
        for _, p in ipairs({path1, path2}) do
            if p and p ~= "" then
                local loaded = pcall(function()
                    g_gui:loadGui(p, "IngredientShopHUD", inst)
                end)
                if loaded and g_gui.guis and g_gui.guis["IngredientShopHUD"] then
                    ok = true
                    xmlPath = p
                    break
                end
            end
        end
    end

    if not ok or not (g_gui.guis and g_gui.guis["IngredientShopHUD"]) then
        pcall(function() inst:delete() end)
        Logging.error("[PIS HUD] XML not found (baseDir=%s, xmlPath=%s)", tostring(baseDir), tostring(xmlPath))
        return false
    end

    IngredientShopHUD.INSTANCE = g_gui.guis["IngredientShopHUD"].target
    return true
end


function IngredientShopHUD.new(target, custom_mt)
    local self = MessageDialog.new(target, custom_mt or IngredientShopHUD_mt)
    self.placeable     = nil
    self.items         = {}
    self.selectedIndex = 0
    return self
end

function IngredientShopHUD:onOpen()
    if g_inputBinding and g_inputBinding.setShowMouseCursor then
        g_inputBinding:setShowMouseCursor(true)
    end

    self.itemsTable  = self:getDescendantById("itemsTable")
    self.itemsSlider = self:getDescendantById("itemsTableSlider")
    self.buyButton   = self:getDescendantById("buyButton")
    self.titleEl     = self:getDescendantById("dialogTitleElement")

    FocusManager:setFocus(self.itemsTable)

    self:pullData()
end

function IngredientShopHUD:onClose()
    if g_inputBinding and g_inputBinding.setShowMouseCursor then
        g_inputBinding:setShowMouseCursor(false)
    end
end

local function money(n) return string.format("%d $", n or 0) end

function IngredientShopHUD:pullData()
    self.items = {}
    local spec = self.placeable and self.placeable.spec_ingredientShop
    if spec then
        if self.titleEl then
            self.titleEl:setText(spec.title or _l10n("$ui_pis_title"))
        end

        for _, it in ipairs(spec.items or {}) do
            table.insert(self.items, {
                index      = it.index,
                icon       = it.icon,
                displayTxt = string.format("%s — %s (x%d)",
                               _l10n(it.name), money(it.price), math.max(1, it.pack or 1))
            })
        end
    end

    if self.itemsTable then
        self.itemsTable:reloadData(true)
        if #self.items > 0 then
            self.itemsTable:setSelectedIndex(1, true, true)
            self.selectedIndex = 1
        end
    end
end

function IngredientShopHUD:getNumberOfSections(list) return 1 end
function IngredientShopHUD:getNumberOfItemsInSection(list, section) return #self.items end
function IngredientShopHUD:getCellTypeForItemInSection(list, section, index) return "rowTemplate" end
function IngredientShopHUD:populateCellForItemInSection(list, section, index, cell)
    local it = self.items[index]; if not it then return end

    local textEl = cell:getDescendantByName("rowText")
    local iconEl = cell:getDescendantByName("rowIcon")

    if textEl then textEl:setText(it.displayTxt or "") end
    if iconEl then
        if it.icon and fileExists(it.icon) then
            iconEl:setVisible(true)
            iconEl:setImageFilename(it.icon)
        else
            iconEl:setVisible(false)
        end
    end
end
function IngredientShopHUD:onListSelectionChanged(list, section, index)
    self.selectedIndex = index or 0
end

function IngredientShopHUD:onClickBuy()
    local idx = self.selectedIndex or 0
    if idx <= 0 or not self.placeable then return end

    -- Проверка инвентаря ЛОКАЛЬНО прежде чем дергать сервер
    if not (_G.Inventory and Inventory.API and Inventory.API.firstFreeSlot) then
        print("[IngredientShopHUD] Inventory API not found")
        return
    end

    local freeSlot = Inventory.API.firstFreeSlot()
    if freeSlot == nil then
        if g_currentMission then
            g_currentMission:showBlinkingWarning(
                g_i18n:getText("ui_pis_noSpace") or "Нет места в инвентаре",
                3000
            )
        end
        return
    end

    -- Мультиплеер: отправляем запрос на сервер
    if g_client ~= nil then
        local conn = g_client:getServerConnection()
        if conn then
            conn:sendEvent(PIS_BuyEvent.new(self.placeable, idx))
        end
        return
    end

    -- Сингл / локальный хост без g_client: делаем покупку целиком локально
    local spec = self.placeable.spec_ingredientShop
    if not spec or not spec.items then return end

    local it = spec.items[idx]
    if not it then return end

    local price = math.max(0, it.price or 0)
    local buyerFarmId = g_currentMission and g_currentMission:getFarmId() or 1
    local farm = g_farmManager and g_farmManager:getFarmById(buyerFarmId)

    if price > 0 then
        if not farm or (farm.money or 0) < price then
            if g_currentMission then
                g_currentMission:showBlinkingWarning(
                    g_i18n:getText("ui_pis_nomoney") or "Недостаточно денег",
                    3000
                )
            end
            return
        end

        if g_currentMission and g_currentMission.addMoney then
            g_currentMission:addMoney(-price, buyerFarmId, MoneyType.OTHER or 0, true, true)
        elseif farm and farm.changeBalance then
            farm:changeBalance(-price, { statistic = (FinanceStats and FinanceStats.CHANGE_SHOP_PURCHASE) or nil })
        end
    end

    local addItem = Inventory.API.addItemInstance
    local pack = math.max(1, it.pack or 1)

    for n = 1, pack do
        local ok, reason = addItem({
            id   = it.id,
            name = it.name,
            desc = it.desc,
            icon = it.icon or "",
            kind = "ingredient",
            hungerGain = 0,
            vigorGain  = 0,
        })

        if not ok then
            if g_currentMission then
                g_currentMission:showBlinkingWarning(
                    g_i18n:getText("ui_pis_noSpace") or "Нет места в инвентаре",
                    3000
                )
            end
            break
        end
    end
end


function IngredientShopHUD:close()
    g_gui:showGui("")
end
