-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 11.11.2025

PlaceableIngredientCooker = {}
PlaceableIngredientCooker.modName = g_currentModName or "hungresystem"
PlaceableIngredientCooker.modDirectory = g_currentModDirectory or ""

------------------------- локалки/утилиты -------------------------
local function _l10n(raw)
    if not raw or raw=="" then return "" end
    if raw:sub(1,1) ~= "$" then return raw end
    local k = raw:sub(2)
    if g_i18n and g_i18n:hasText(k) then return g_i18n:getText(k) end
    if k:sub(1,5)=="l10n_" and g_i18n:hasText(k:sub(6)) then return g_i18n:getText(k:sub(6)) end
    return k
end

local function _nowMs() return g_time or 0 end

local function _notifyTop(title, text)
    if g_currentMission then
        g_currentMission:showBlinkingWarning(("[%s] %s"):format(title or "Cook", text or ""), 3000)
    end
end

local function _splitList(str)
    local out = {}; if not str or str=="" then return out end
    for token in string.gmatch(str, "[^;,]+") do
        local s = token:gsub("^%s+",""):gsub("%s+$",""); if s~="" then table.insert(out, s) end
    end
    return out
end

local function _isLocalPlayerActor(otherId)
    if not otherId or otherId==0 or not g_localPlayer then return false end
    if otherId == g_localPlayer.rootNode or otherId == g_localPlayer.playerNode then return true end
    local parent = getParent(otherId)
    while parent ~= 0 do
        if parent == g_localPlayer.rootNode then return true end
        parent = getParent(parent)
    end
    return false
end

local function _topNotify(title, text, icon)
    local t  = (title ~= nil) and tostring(title) or ""
    local l1 = (text  ~= nil) and tostring(text)  or ""
    local l2 = ""

    local hud = g_currentMission and g_currentMission.hud
    if hud and hud.topNotification and hud.topNotification.setNotification then
        hud.topNotification:setNotification(
            t,      -- title
            l1,     -- text
            l2,     -- info
            nil,    -- iconKey
            4000    -- duration, 4 секунды
        )
    else
        print(("[PIC] %s | %s"):format(t, l1))
    end
end

local function _hudRefreshIfOpen(self)
    if not (g_gui and g_gui:getIsGuiVisible()) then return end
    if not (IngredientCookerHUD and IngredientCookerHUD.INSTANCE) then return end
    local hud = IngredientCookerHUD.INSTANCE
    if hud.placeable ~= self then return end

    if hud.pullData then hud:pullData() end
    if hud.updateStatus then hud:updateStatus() end
    if hud.updateButtons then hud:updateButtons() end
    if hud.itemsTable and hud.itemsTable.reloadData then
        hud.itemsTable:reloadData(true)
    end
end

------------------------- Activatable -------------------------
PIC_Activatable = {}
local PIC_Activatable_mt = Class(PIC_Activatable)

function PIC_Activatable.new(placeable)
    local self = setmetatable({}, PIC_Activatable_mt)
    self.placeable    = placeable
    self.activateText = (g_i18n and g_i18n:getText("ui_pic_openHint")) or "Открыть кухню (R)"
    return self
end

function PIC_Activatable:getIsActivatable()
    if g_localPlayer == nil then return false end
    if g_localPlayer.getIsInVehicle and g_localPlayer:getIsInVehicle() then return false end
    return self.placeable ~= nil
end

function PIC_Activatable:run()
    if not g_gui then return end
    if not (g_gui.guis and g_gui.guis["IngredientCookerHUD"]) then
        if IngredientCookerHUD and IngredientCookerHUD.register then
            IngredientCookerHUD.register()
        else
            print("[PIC] IngredientCookerHUD module not found"); return
        end
    end
    local guiDef = g_gui.guis and g_gui.guis["IngredientCookerHUD"]
    if guiDef and guiDef.target then
        guiDef.target.placeable = self.placeable
    end
    g_gui:showDialog("IngredientCookerHUD")
end

------------------------- GUI open -------------------------
function PlaceableIngredientCooker:picOpenGUI()
    if not g_gui then return end
    if IngredientCookerHUD and IngredientCookerHUD.register then
        IngredientCookerHUD.register()
    end
    local guiDef = g_gui.guis and g_gui.guis["IngredientCookerHUD"]
    if not guiDef then return end
    local inst = guiDef.target
    if inst then
        inst.placeable = self
        g_gui:showGui("IngredientCookerHUD")
        if inst.pullData then inst:pullData() end
        if inst.updateStatus then inst:updateStatus() end
        if inst.updateButtons then inst:updateButtons() end
    end
end

------------------------- Anim / Vis -------------------------
local function _animResolve(self, it)
    if it._animResolved ~= nil then return it._animResolved end
    it._animResolved=false; it._anim=nil
    if not it.animNode or it.animNode==0 or not it.animClip or it.animClip=="" then return false end
    local cs = getAnimCharacterSet(it.animNode); if not cs then return false end
    local clipIdx = getAnimClipIndex(cs, it.animClip); if not clipIdx or clipIdx==-1 then return false end
    assignAnimTrackClip(cs, 0, clipIdx)
    setAnimTrackLoopState(cs, 0, it.animLoop==true)
    setAnimTrackSpeedScale(cs, 0, 0); setAnimTrackTime(cs, 0, 0, true); disableAnimTrack(cs, 0)
    it._anim = {charSet=cs, track=0, clipIndex=clipIdx, duration=getAnimClipDuration(cs, clipIdx) or 0}
    it._animResolved=true; return true
end

local function _visResolve(self, it)
    if it._visResolved ~= nil then return it._visResolved end
    it._visResolved=false; it._vis={}
    if it.visNodes and type(it.visNodes)=="string" then
        for _, idx in ipairs(_splitList(it.visNodes)) do
            local node = I3DUtil.indexToObject(self.components, idx, self.i3dMappings)
            if node and node~=0 then table.insert(it._vis, {node=node, was=getVisibility(node)}) end
        end
    end
    if it._visExtra then
        for _, node in ipairs(it._visExtra) do
            if node and node~=0 then table.insert(it._vis, {node=node, was=getVisibility(node)}) end
        end
    end
    it._visResolved=true; return true
end

local function _visSet(self, it, visible)
    if not it or not _visResolve(self,it) then return end
    for _,e in ipairs(it._vis) do if e.node then setVisibility(e.node, visible and true or false) end end
end

local function _animStart(self, it)
    local spec = self.spec_ingredientCooker; if not spec then return end
    _visSet(self, it, true)
    if not _animResolve(self,it) then spec._animActive=false; spec._animItem=it; spec._animEnd=nil; return end
    local a = it._anim
    setAnimTrackLoopState(a.charSet, a.track, it.animLoop==true)
    setAnimTrackTime(a.charSet, a.track, 0, true)
    setAnimTrackSpeedScale(a.charSet, a.track, math.max(0.0001, tonumber(it.animSpeed or 1.0) or 1.0))
    enableAnimTrack(a.charSet, a.track)
    spec._animActive=true; spec._animItem=it; spec._animEnd=nil
    if it.animLoop~=true and a.duration>0 then spec._animEnd=(g_time or 0)+math.floor(a.duration*1000) end
end

local function _animStop(self)
    local spec = self.spec_ingredientCooker; if not spec then return end
    if spec._animItem and spec._animItem._anim then
        local a = spec._animItem._anim
        setAnimTrackSpeedScale(a.charSet, a.track, 0); setAnimTrackTime(a.charSet, a.track, 0, true); disableAnimTrack(a.charSet, 0)
    end
    _visSet(self, spec._animItem, false)
    spec._animActive=false; spec._animItem=nil; spec._animEnd=nil
end

------------------------- Inventory helpers -------------------------
local function _buildCounts()
    local counts = {}
    if not Inventory or not Inventory.items then return counts end
    for slot=1, Inventory.maxSlots do
        local it = Inventory.items[slot]
        if it and it.id and it.id~="" then
            counts[it.id] = (counts[it.id] or 0) + 1
        end
    end
    return counts
end

local function _hasAllIngredients(recipe)
    local counts = _buildCounts()
    for _, ing in ipairs(recipe or {}) do
        if (counts[ing.id] or 0) < (ing.count or 1) then return false, ing.id end
    end
    return true
end

local function _consumeIngredients(recipe)
    for _, ing in ipairs(recipe or {}) do
        local need = math.max(1, ing.count or 1)
        for slot=1, Inventory.maxSlots do
            if need<=0 then break end
            local it = Inventory.items[slot]
            if it and tostring(it.id)==tostring(ing.id) then
                Inventory.API.removeAt(slot)
                need = need - 1
            end
        end
        if need>0 then return false end
    end
    return true
end

------------------------- Регистрация в спеках -------------------------
function PlaceableIngredientCooker.prerequisitesPresent(specializations) return true end

function PlaceableIngredientCooker.registerEventListeners(placeableType)
    SpecializationUtil.registerEventListener(placeableType, "onLoad",         PlaceableIngredientCooker)
    SpecializationUtil.registerEventListener(placeableType, "onDelete",       PlaceableIngredientCooker)
    SpecializationUtil.registerEventListener(placeableType, "onUpdate",       PlaceableIngredientCooker)
    SpecializationUtil.registerEventListener(placeableType, "saveToXMLFile",  PlaceableIngredientCooker) -- ← добавили
end


function PlaceableIngredientCooker.registerFunctions(placeableType)
    SpecializationUtil.registerFunction(placeableType, "picTriggerCallback",          PlaceableIngredientCooker.picTriggerCallback)

    SpecializationUtil.registerFunction(placeableType, "picServerStart",              PlaceableIngredientCooker.picServerStart)
    SpecializationUtil.registerFunction(placeableType, "picServerFinalizeIfReady",    PlaceableIngredientCooker.picServerFinalizeIfReady)
    SpecializationUtil.registerFunction(placeableType, "picServerConsumeReady",       PlaceableIngredientCooker.picServerConsumeReady)
    SpecializationUtil.registerFunction(placeableType, "picServerTakeToInventory",    PlaceableIngredientCooker.picServerTakeToInventory)
    SpecializationUtil.registerFunction(placeableType, "picServerDiscard",            PlaceableIngredientCooker.picServerDiscard)
end

function PlaceableIngredientCooker.initSpecialization()
    local saveSchema = Placeable.xmlSchemaSavegame
    local ns = (PlaceableIngredientCooker.modName or "hungresystem") .. ".ingredientCooker"

    saveSchema:register(XMLValueType.BOOL,  "placeables.placeable(?)."..ns.."#cooking",      "Идёт готовка", false)
    saveSchema:register(XMLValueType.INT,   "placeables.placeable(?)."..ns.."#currentIndex", "Индекс текущего рецепта (1..N; 0=нет)", 0)
    saveSchema:register(XMLValueType.INT,   "placeables.placeable(?)."..ns.."#remainingMs",  "Остаток времени готовки (мс)", 0)

    local base = "placeables.placeable(?)."..ns..".ready"
    saveSchema:register(XMLValueType.INT,   base.."#count",                       "Сколько предметов на полке", 0)
    saveSchema:register(XMLValueType.INT,   base..".item(?)#index",               "Индекс рецепта (1..N)")
    saveSchema:register(XMLValueType.STRING,base..".item(?)#name",                "Имя (кеш)")
    saveSchema:register(XMLValueType.STRING,base..".item(?)#icon",                "Иконка (путь)")
    saveSchema:register(XMLValueType.STRING,base..".item(?)#kind",                "Тип: food/effect")
    saveSchema:register(XMLValueType.STRING,base..".item(?)#effectId",            "ID эффекта (если есть)")
    saveSchema:register(XMLValueType.STRING,base..".item(?)#desc",                "Описание (кеш)")
    saveSchema:register(XMLValueType.INT,   base..".item(?)#hungerGain",          "Сытость %+")
    saveSchema:register(XMLValueType.INT,   base..".item(?)#vigorGain",           "Бодрость %+")
    saveSchema:register(XMLValueType.INT,   base..".item(?)#resultCount",         "Сколько выдавать в инвентарь", 1)
    saveSchema:register(XMLValueType.STRING,base..".item(?)#resultId",            "ID результата (для инвентаря)")
end


function PlaceableIngredientCooker.registerXMLPaths(schema, basePath)
    schema:register(XMLValueType.STRING,     basePath..".ingredientCooker#title",        "Title")
    schema:register(XMLValueType.NODE_INDEX, basePath..".ingredientCooker#triggerNode",  "Trigger node")

    local item = basePath..".ingredientCooker.items.item(?)"
    schema:register(XMLValueType.STRING, item.."#name", "Name")
    schema:register(XMLValueType.STRING, item.."#desc", "Desc")
    schema:register(XMLValueType.STRING, item.."#icon", "Icon")
    schema:register(XMLValueType.INT,    item.."#cookSec", "Seconds", 60)
    schema:register(XMLValueType.INT,    item.."#readyCap", "Cap", 0)
    schema:register(XMLValueType.FLOAT,  item.."#hungerGain", "Hunger %+")
    schema:register(XMLValueType.FLOAT,  item.."#vigorGain",  "Vigor %+")
    schema:register(XMLValueType.STRING, item.."#resultId",   "Result inv. id")
    schema:register(XMLValueType.INT,    item.."#resultCount","Result count",1)

    schema:register(XMLValueType.NODE_INDEX, item.."#animNode", "Anim node")
    schema:register(XMLValueType.STRING,     item.."#animClip", "Anim clip")
    schema:register(XMLValueType.BOOL,       item.."#animLoop", "Loop", true)
    schema:register(XMLValueType.FLOAT,      item.."#animSpeed","Speed",1.0)

    schema:register(XMLValueType.STRING,     item.."#visNodes","Visibility list (; or ,)")
    schema:register(XMLValueType.NODE_INDEX, item..".visNode(?)#node","Visibility node (repeatable)")

    schema:register(XMLValueType.STRING,     item..".recipe.ing(?)#id","Ingredient id")
    schema:register(XMLValueType.INT,        item..".recipe.ing(?)#count","Count",1)
end

------------------------- onLoad/onDelete/onUpdate -------------------------
function PlaceableIngredientCooker:onLoad(savegame)
    self.spec_ingredientCooker = self.spec_ingredientCooker or {}
    local spec = self.spec_ingredientCooker
    local xml  = self.xmlFile

    -- Заголовок
    local ttl = xml:getValue("placeable.ingredientCooker#title") or "$ui_pic_title"
    if ttl:sub(1,1) == "$" and g_i18n and g_i18n:hasText(ttl:sub(2)) then
        spec.title = g_i18n:getText(ttl:sub(2))
    else
        spec.title = ttl
    end

    -- Триггер
    spec.triggerNode = xml:getValue("placeable.ingredientCooker#triggerNode", nil, self.components, self.i3dMappings)
    if spec.triggerNode ~= nil then
        addTrigger(spec.triggerNode, "picTriggerCallback", self)
    else
        Logging.xmlWarning(self.xmlFile, "[PIC] Missing trigger node 'placeable.ingredientCooker#triggerNode'")
    end

    spec.items = {}
    local i = 0
    while true do
        local key = ("placeable.ingredientCooker.items.item(%d)"):format(i)
        if not xml:hasProperty(key) then break end

        local name = xml:getValue(key .. "#name") or ("Dish " .. (i+1))
        if type(name) == "string" and name:sub(1,1) == "$" and g_i18n and g_i18n:hasText(name:sub(2)) then
            name = g_i18n:getText(name:sub(2))
        end

        local desc = xml:getValue(key .. "#desc")

        local iconRel = xml:getValue(key .. "#icon") or ""
        local iconAbs = ""
        if iconRel ~= "" then
            iconAbs = Utils.getFilename(iconRel, PlaceableIngredientCooker.modDirectory)
            if not fileExists(iconAbs) then
                iconAbs = ""
            end
        end

        local cookSec    = math.max(1, xml:getValue(key .. "#cookSec", 60))
        local readyCap   = math.max(0, xml:getValue(key .. "#readyCap", 0))
        local hunger     = math.floor(xml:getValue(key .. "#hungerGain", 0) or 0)
        local vigor      = math.floor(xml:getValue(key .. "#vigorGain",  0) or 0)
        local resultId   = xml:getValue(key .. "#resultId")
        local resultCnt  = math.max(1, xml:getValue(key .. "#resultCount", 1))

        -- Анимация
        local animNode   = xml:getValue(key .. "#animNode", nil, self.components, self.i3dMappings)
        local animClip   = xml:getValue(key .. "#animClip")
        local animLoop   = xml:getValue(key .. "#animLoop", true)
        local animSpeed  = xml:getValue(key .. "#animSpeed", 1.0)

        -- Видимость
        local visListStr = xml:getValue(key .. "#visNodes")
        local visExtra   = {}
        xml:iterate(key .. ".visNode", function(_, nkey)
            local n = xml:getValue(nkey .. "#node", nil, self.components, self.i3dMappings)
            if n and n ~= 0 then table.insert(visExtra, n) end
        end)

        -- Рецепт
        local recipe = {}
        xml:iterate(key .. ".recipe.ing", function(_, rk)
            local id = xml:getValue(rk .. "#id")
            local ct = math.max(1, xml:getValue(rk .. "#count", 1))
            if id and id ~= "" then
                table.insert(recipe, {id = id, count = ct})
            end
        end)

        table.insert(spec.items, {
            index         = #spec.items + 1,
            name          = name,
            desc          = desc,
            icon          = iconAbs,
            iconRel       = iconRel,
            cookSec       = cookSec,
            readyCap      = readyCap,
            hungerGain    = hunger,
            vigorGain     = vigor,
            resultId      = resultId,
            resultCount   = resultCnt,
            recipe        = recipe,

            -- анимация
            animNode      = animNode,
            animClip      = animClip,
            animLoop      = animLoop == true,
            animSpeed     = tonumber(animSpeed) or 1.0,
            _animResolved = nil,
            _anim         = nil,

            -- видимость
            visNodes      = visListStr,
            _visExtra     = visExtra,
            _visResolved  = nil,
            _vis          = nil
        })
        i = i + 1
    end

    spec.state = { cooking = false, current = nil, endTimeMs = 0, ready = false }
    spec.readyItems, spec.readyCounts, spec.readyCount = {}, {}, 0
    spec._animActive, spec._animItem, spec._animEnd = false, nil, nil

    -- Activatable
    if not self.picActivatable then
        self.picActivatable = PIC_Activatable.new(self)
        self.picActivatable.activateText = string.format("%s: %s",
            (g_i18n and g_i18n:getText("ui_pic_openHint")) or "Открыть кухню (R)",
            spec.title or "")
    end

    if g_gui and (not (g_gui.guis and g_gui.guis["IngredientCookerHUD"])) and IngredientCookerHUD and IngredientCookerHUD.register then
        IngredientCookerHUD.register()
    end

    ----------------------------------------------------------------
    -- === ЧТЕНИЕ СЕЙВА ===
    ----------------------------------------------------------------
    if savegame ~= nil and savegame.xmlFile ~= nil then
        local ns      = (PlaceableIngredientCooker.modName or "hungresystem") .. ".ingredientCooker"
        local keyBase = savegame.key .. "." .. ns

        local wasCooking  = savegame.xmlFile:getValue(keyBase .. "#cooking", false)
        local currentIdx  = savegame.xmlFile:getValue(keyBase .. "#currentIndex", 0)
        local remainingMs = math.max(0, savegame.xmlFile:getValue(keyBase .. "#remainingMs", 0))

        local rKey = keyBase .. ".ready"
        local rCnt = math.max(0, savegame.xmlFile:getValue(rKey .. "#count", 0))
        for j = 0, rCnt - 1 do
            local ikey = string.format("%s.item(%d)", rKey, j)
            local item = {
                index       = savegame.xmlFile:getValue(ikey .. "#index", 0),
                name        = savegame.xmlFile:getValue(ikey .. "#name", ""),
                icon        = savegame.xmlFile:getValue(ikey .. "#icon", ""),
                iconRel     = "",
                kind        = (savegame.xmlFile:getValue(ikey .. "#kind", "food") or "food"),
                effectId    = savegame.xmlFile:getValue(ikey .. "#effectId", ""),
                desc        = savegame.xmlFile:getValue(ikey .. "#desc", ""),
                hungerGain  = math.floor(savegame.xmlFile:getValue(ikey .. "#hungerGain", 0) or 0),
                vigorGain   = math.floor(savegame.xmlFile:getValue(ikey .. "#vigorGain",  0) or 0),
                resultCount = math.max(1, savegame.xmlFile:getValue(ikey .. "#resultCount", 1) or 1),
                resultId    = savegame.xmlFile:getValue(ikey .. "#resultId", "")
            }
            if item.resultId == "" then item.resultId = nil end

            table.insert(spec.readyItems, item)
            if item.index and item.index > 0 then
                spec.readyCounts[item.index] = (spec.readyCounts[item.index] or 0) + 1
            end
        end

        spec.readyCount  = #spec.readyItems
        spec.state.ready = spec.readyCount > 0

        if wasCooking and currentIdx > 0 and remainingMs > 0 and spec.items[currentIdx] then
            spec.state.cooking   = true
            spec.state.current   = {}
            for k, v in pairs(spec.items[currentIdx]) do spec.state.current[k] = v end
            spec.state.current.index = currentIdx
            spec.state.endTimeMs = (g_time or 0) + remainingMs

            if _visSet   then _visSet(self, spec.state.current, true) end
            if _animStart then _animStart(self, spec.state.current) end
            self:raiseActive()
        end
    end
end

function PlaceableIngredientCooker:saveToXMLFile(xmlFile, key)
    local spec = self.spec_ingredientCooker
    if not spec then return end
    local base = key

    local cooking = (spec.state.cooking == true)
    local currentIndex = (spec.state.current and spec.state.current.index) or 0
    local remainingMs = 0
    if cooking then
        remainingMs = math.max(0, (spec.state.endTimeMs or 0) - (g_time or 0))
    end

    xmlFile:setValue(base.."#cooking",      cooking)
    xmlFile:setValue(base.."#currentIndex", currentIndex)
    xmlFile:setValue(base.."#remainingMs",  remainingMs)

    local rBase = base..".ready"
    local cnt = #spec.readyItems
    xmlFile:setValue(rBase.."#count", cnt)
    for i=1,cnt do
        local it = spec.readyItems[i] or {}
        local iKey = string.format("%s.item(%d)", rBase, i-1)
        xmlFile:setValue(iKey.."#index",       it.index or 0)
        xmlFile:setValue(iKey.."#name",        tostring(it.name or ""))
        xmlFile:setValue(iKey.."#icon",        tostring(it.icon or ""))
        xmlFile:setValue(iKey.."#kind",        tostring(it.kind or "food"))
        xmlFile:setValue(iKey.."#effectId",    tostring(it.effectId or ""))
        xmlFile:setValue(iKey.."#desc",        tostring(it.desc or ""))
        xmlFile:setValue(iKey.."#hungerGain",  math.floor(tonumber(it.hungerGain) or 0))
        xmlFile:setValue(iKey.."#vigorGain",   math.floor(tonumber(it.vigorGain)  or 0))
        xmlFile:setValue(iKey.."#resultCount", math.max(1, tonumber(it.resultCount or 1) or 1))
        xmlFile:setValue(iKey.."#resultId",    tostring(it.resultId or ""))
    end
end

-- Клиент/сервер:
function PlaceableIngredientCooker:_picApplyCookAnimFromState()
    local spec = self.spec_ingredientCooker
    if not spec then return end

    if spec.state.cooking and spec.state.current then
        local it = spec.state.current
        if it.index and spec.items[it.index] then
            local src = spec.items[it.index]
            it.animNode   = src.animNode
            it.animClip   = src.animClip
            it.animLoop   = src.animLoop
            it.animSpeed  = src.animSpeed
            it.visNodes   = src.visNodes
            it._visExtra  = src._visExtra
        end
        if _visSet   then _visSet(self, it, true) end
        if _animStart then _animStart(self, it) end
    else
        if _animStop then _animStop(self) end
    end
end

function PlaceableIngredientCooker:onDelete()
    local spec = self.spec_ingredientCooker
    if spec and spec.triggerNode then
        removeTrigger(spec.triggerNode)
        spec.triggerNode = nil
    end
    if self.picActivatable then
        g_currentMission.activatableObjectsSystem:removeActivatable(self.picActivatable)
        self.picActivatable = nil
    end
end

function PlaceableIngredientCooker:onUpdate(dt)
    local spec = self.spec_ingredientCooker
    if not spec then return end

    if spec.state and spec.state.cooking then
        self:raiseActive()
    end

    if spec.state and spec.state.cooking and (g_time or 0) >= (spec.state.endTimeMs or 0) then
        local cur = spec.state.current
        if cur then
            local outN = tonumber(cur.resultCount) or 1
            if outN < 1 then outN = 1 end

            local itemDef = (spec.items and spec.items[cur.index]) or cur
            local cap = tonumber(itemDef and itemDef.readyCap) or 0

            local addN = outN
            if cap > 0 then
                local have = spec.readyCounts[cur.index] or 0
                local remain = cap - have
                if remain < addN then
                    addN = math.max(0, remain)
                end
            end

            if addN > 0 then
                for _ = 1, addN do
                    table.insert(spec.readyItems, {
                        index       = cur.index,
                        name        = cur.name,
                        icon        = cur.icon,
                        desc        = cur.desc,
                        hungerGain  = cur.hungerGain,
                        vigorGain   = cur.vigorGain,
                        resultId    = cur.resultId,
                        resultCount = cur.resultCount
                    })
                end
                spec.readyCounts[cur.index] = (spec.readyCounts[cur.index] or 0) + addN
            end

            spec.readyCount  = #spec.readyItems
            spec.state.ready = spec.readyCount > 0
        end

        spec.state.cooking   = false
        spec.state.current   = nil
        spec.state.endTimeMs = 0
        if _animStop then _animStop(self) end

        local ttl = spec.title or (g_i18n and g_i18n:getText("ui_pic_title")) or "Кухня"
        local msg = (g_i18n and g_i18n:getText("ui_pic_ready")) or "Блюдо готово"
        _topNotify(ttl, msg, cur and cur.icon or nil)

        _hudRefreshIfOpen(self)

        if PIC_StateSyncEvent and PIC_StateSyncEvent.send then
            PIC_StateSyncEvent.send(self)
        end
    end
end

------------------------- Server API -------------------------
local function _capReached(spec, itemIndex, cap)
    if cap<=0 then return false end
    return (spec.readyCounts[itemIndex] or 0) >= cap
end

function PlaceableIngredientCooker:picServerStart(itemIndex)
    local spec = self.spec_ingredientCooker
    if not spec then return false, "noSpec" end

    local it = spec.items and spec.items[itemIndex]
    if not it then return false, "noItem" end
    if spec.state.cooking then return false, "busy" end

    local cap = it.readyCap or 0
    if cap > 0 then
        local haveReady = spec.readyCounts[itemIndex] or 0
        local outCount  = math.max(1, tonumber(it.resultCount or 1) or 1)
        if (haveReady + outCount) > cap then
            _topNotify((g_i18n and g_i18n:getText("ui_pic_no_space")) or "Нет места для блюда, съешьте или заберите в инвентарь")
            return false, "cap"
        end
    end

    spec.state.cooking   = true
    local copy = {}
    for k,v in pairs(it) do copy[k]=v end
    copy.index           = itemIndex
    spec.state.current   = copy
    spec.state.endTimeMs = (g_time or 0) + math.max(1, it.cookSec or 1) * 1000
    spec.state.ready     = false

    if _animStart then _animStart(self, copy) end

    if g_server and PIC_StateSyncEvent then
        g_server:broadcastEvent(PIC_StateSyncEvent.new(self), nil, nil, self)
    end

    self:raiseActive()
    return true, "ok"
end

function PlaceableIngredientCooker:picServerFinalizeIfReady()
    local spec = self.spec_ingredientCooker
    if not spec or not spec.state or spec.state.cooking ~= true then return false, "idle" end
    if (g_time or 0) < (spec.state.endTimeMs or 0) then return false, "notFinished" end

    local cur = spec.state.current
    if not cur then return false, "noCurrent" end

    if _animStop then _animStop(self) end

    local addN = math.max(1, tonumber(cur.resultCount or 1) or 1)

    local cap = cur.readyCap or 0
    if cap > 0 then
        local have = spec.readyCounts[cur.index] or 0
        addN = math.max(0, math.min(addN, cap - have))
    end

    for _ = 1, addN do
        table.insert(spec.readyItems, {
            index       = cur.index,
            name        = cur.name,
            icon        = cur.icon,
            desc        = cur.desc,
            hungerGain  = cur.hungerGain,
            vigorGain   = cur.vigorGain,
            resultId    = cur.resultId,
            resultCount = cur.resultCount
        })
    end
    spec.readyCounts[cur.index] = (spec.readyCounts[cur.index] or 0) + addN
    spec.readyCount  = #spec.readyItems
    spec.state.ready = spec.readyCount > 0

    spec.state.cooking   = false
    spec.state.current   = nil
    spec.state.endTimeMs = 0

    local ttl = spec.title or (g_i18n and g_i18n:getText("ui_pic_title")) or "Кухня"
    local msg = (g_i18n and g_i18n:getText("ui_pic_ready")) or "Блюдо готово"
    _topNotify(ttl, msg, cur and cur.icon or nil)

    _hudRefreshIfOpen(self)

    if PIC_StateSyncEvent and PIC_StateSyncEvent.send then
        PIC_StateSyncEvent.send(self)
    end

    return true
end

function PlaceableIngredientCooker:picServerConsumeReady(farmId, readyIndex)
    local spec = self.spec_ingredientCooker
    if not spec then return false, "noSpec" end
    if spec.state.cooking then return false, "busy" end
    if (spec.readyCount or 0) <= 0 then return false, "nothingReady" end

    local idxInReady, picked = nil, nil
    for i, r in ipairs(spec.readyItems) do
        if (not readyIndex) or (r.index == readyIndex) then
            idxInReady, picked = i, r
            break
        end
    end
    if not picked then return false, "notFound" end

    local base = (spec.items and picked.index and spec.items[picked.index]) or picked or {}
    local kind = (base.effectId and base.effectId ~= "" and "effect") or (base.kind or "food")
    local ttl  = spec.title or (g_i18n and g_i18n:getText("ui_pic_title")) or "Кухня"

    local payload = {
        hungerGain     = math.floor(tonumber(picked.hungerGain or base.hungerGain or 0) or 0),
        vigorGain      = math.floor(tonumber(picked.vigorGain  or base.vigorGain  or 0) or 0),
        kind           = tostring(kind),
        icon           = picked.icon or base.icon or "",
        placeableTitle = ttl,
        effectId       = (kind == "effect") and (base.effectId or "") or "",
        effectsFile    = (kind == "effect") and (spec.effectsFileAbs or base.effectsFile or "") or "",
        boostSec       = tonumber(base.boostSec or 0) or 0,
        boostWalk      = tonumber(base.boostWalk or 0) or 0,
        boostRun       = tonumber(base.boostRun  or 0) or 0,
    }

    table.remove(spec.readyItems, idxInReady)
    spec.readyCounts[picked.index] = math.max(0, (spec.readyCounts[picked.index] or 1) - 1)
    spec.readyCount  = #spec.readyItems
    spec.state.ready = spec.readyCount > 0

    _hudRefreshIfOpen(self)

    if PIC_StateSyncEvent and PIC_StateSyncEvent.send then
        PIC_StateSyncEvent.send(self)
    end

    return true, payload
end

-- ЗАБРАТЬ ГОТОВЫЙ ПРЕДМЕТ В ИНВЕНТАРЬ
function PlaceableIngredientCooker:picServerTakeToInventory(farmId, readyIndex)
    local spec = self.spec_ingredientCooker
    if not spec or not spec.readyItems or #spec.readyItems == 0 then
        return false, "nothingReady"
    end

    readyIndex = math.max(1, readyIndex or 1)

    local slotIdx = nil
    local picked  = nil
    for i, item in ipairs(spec.readyItems) do
        if i == readyIndex or item.index == readyIndex then
            slotIdx = i
            picked  = item
            break
        end
    end

    if not picked or not slotIdx then
        return false, "notFound"
    end

    local baseRecipe = (spec.items and picked.index and spec.items[picked.index]) or picked

    local ttl      = spec.title or (g_i18n and g_i18n:getText("ui_pic_title")) or "Кухня"
    local resultId = baseRecipe.resultId or picked.resultId or ""
    local name     = baseRecipe.name     or picked.name     or "Еда"

    local iconRel = baseRecipe.iconRel or picked.iconRel or baseRecipe.icon or picked.icon or ""

    if iconRel:lower():sub(1,6) == "datas/" then
        iconRel = "data/" .. iconRel:sub(7)
    end

    local kind = (baseRecipe.effectId and baseRecipe.effectId ~= "") and "effect"
        or (baseRecipe.kind or picked.kind or "food")

    local payload = {
        id             = resultId ~= "" and resultId or nil,
        name           = name,
        icon           = iconRel,
        kind           = kind,
        hungerGain     = math.floor(tonumber(baseRecipe.hungerGain or picked.hungerGain or 0) or 0),
        vigorGain      = math.floor(tonumber(baseRecipe.vigorGain  or picked.vigorGain  or 0) or 0),
        effectId       = (kind == "effect") and (baseRecipe.effectId or "") or nil,
        effectsFile    = (kind == "effect") and (spec.effectsFileAbs or baseRecipe.effectsFile or "") or nil,
        count          = 1,
        placeableTitle = ttl
    }

    table.remove(spec.readyItems, slotIdx)
    if picked.index then
        spec.readyCounts[picked.index] = math.max(0, (spec.readyCounts[picked.index] or 1) - 1)
    end

    spec.readyCount  = #spec.readyItems
    spec.state.ready = spec.readyCount > 0

    _hudRefreshIfOpen(self)
    if PIC_StateSyncEvent and PIC_StateSyncEvent.send then
        PIC_StateSyncEvent.send(self)
    end

    -- Уведомление
    local dishName = type(name) == "string" and _l10n(name) or tostring(name)
    _topNotify("Кухня", "Забрано: " .. dishName)

    return true, payload
end


function PlaceableIngredientCooker:picServerDiscard(farmId, readyIndex)
    local spec = self.spec_ingredientCooker
    if not spec or not spec.readyItems or #spec.readyItems == 0 then return end

    readyIndex = math.max(1, readyIndex or 1)
    local item = spec.readyItems[readyIndex]
    if not item then return end

    table.remove(spec.readyItems, readyIndex)

    if item.index then
        spec.readyCounts[item.index] = math.max(0, (spec.readyCounts[item.index] or 1) - 1)
    end

    spec.readyCount = #spec.readyItems
    spec.state.ready = spec.readyCount > 0

    _topNotify("Кухня", "Выкинуто 1 порция")
    _hudRefreshIfOpen(self)
    PIC_StateSyncEvent.send(self)
end

------------------------- Trigger callback -------------------------
function PlaceableIngredientCooker:picTriggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
    if not (onEnter or onLeave) then return end
    if g_localPlayer == nil then return end
    if otherActorId ~= g_localPlayer.rootNode then return end

    if onEnter then
        if Platform.gameplay and Platform.gameplay.autoActivateTrigger and self.picActivatable:getIsActivatable() then
            self.picActivatable:run()
        else
            g_currentMission.activatableObjectsSystem:addActivatable(self.picActivatable)
        end
    end
    if onLeave then
        g_currentMission.activatableObjectsSystem:removeActivatable(self.picActivatable)
    end
end

local function _lf_l10nResolve(s)
    if s == nil or s == "" then return "" end
    s = tostring(s)
    if g_i18n and s:sub(1,6) == "$l10n_" then
        local k = s:sub(7)
        local t = g_i18n:getText(k)
        if t and t ~= "" then return t end
    end
    if s:sub(1,1) == "$" and g_i18n then
        local k = s:sub(2)
        local t = g_i18n:getText(k)
        if t and t ~= "" then return t end
    end
    return s
end

if PlaceableIngredientCooker ~= nil then
	function PlaceableIngredientCooker:picServerFinalizeIfReady()
		local spec = self.spec_ingredientCooker
		if not spec or not spec.current then
			return
		end

		local cur = spec.current
		if cur.state ~= "cooking" and cur.state ~= "ready" then
			return
		end

		if (cur.doneTime or 0) > (g_time or 0) then
			return
		end

		local readyCap = math.max(1, cur.readyCap or 1)
		if (cur.count or 0) < readyCap then
			cur.state = "ready"
			return
		end

		cur.count    = (cur.count or 0) - readyCap
		cur.state    = "ready"
		spec.readyItems = spec.readyItems or {}

		local addN = math.max(1, cur.resultCount or 1)
		for _ = 1, addN do
			table.insert(spec.readyItems, {
				index       = cur.index,                      -- индекс в spec.items
				name        = cur.name,                       -- чисто для HUD
				desc        = cur.desc,
				icon        = cur.icon,
				kind        = "food",
				resultId    = cur.resultId or "",             -- id готового предмета (food.beef и т.п.)
				placeableId = self.placerId or nil
			})
		end

		if cur.obj and cur.obj.resetAnimation and cur.animClip then
			cur.obj:resetAnimation(cur.animClip, true)
		end

		if _hudRefreshIfOpen ~= nil then
			_hudRefreshIfOpen(self)
		end
	end

	function PlaceableIngredientCooker:picServerConsumeReady(farmId, readyIndex)
		local spec = self.spec_ingredientCooker
		if not spec or not spec.readyItems then return false end

		readyIndex = math.max(1, readyIndex or 1)
		local picked = spec.readyItems[readyIndex]
		if not picked then return false end

		local base = spec.items and spec.items[picked.index] or picked

		local hungerGain = math.floor(tonumber(base.hungerGain or 0) or 0)
		local vigorGain  = math.floor(tonumber(base.vigorGain or 0) or 0)
		local kind = base.kind or picked.kind or "food"

		table.remove(spec.readyItems, readyIndex)

		if picked.index then
			spec.readyCounts[picked.index] = math.max(0, (spec.readyCounts[picked.index] or 1) - 1)
		end

		spec.readyCount = #spec.readyItems
		spec.state.ready = spec.readyCount > 0

		_hudRefreshIfOpen(self)

		PIC_StateSyncEvent.send(self)

		return true, {hungerGain = hungerGain, vigorGain = vigorGain, kind = kind}
	end
end
