-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 18.11.2025 (MP FIX: int8→int16 + absolute icon path)

------------------------------------------------------------
-- START (запуск готовки)
------------------------------------------------------------
PIC_StartEvent = {}
local PIC_StartEvent_mt = Class(PIC_StartEvent, Event)
InitEventClass(PIC_StartEvent, "PIC_StartEvent")

function PIC_StartEvent.emptyNew()
    return Event.new(PIC_StartEvent_mt)
end

function PIC_StartEvent.new(placeable, itemIndex)
    local self = PIC_StartEvent.emptyNew()
    self.placeable = placeable
    self.itemIndex = math.max(1, itemIndex or 1)
    return self
end

function PIC_StartEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
    streamWriteUIntN(streamId, self.itemIndex, 16)
end

function PIC_StartEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)
    self.itemIndex = streamReadUIntN(streamId, 16)
    self:run(connection)
end

function PIC_StartEvent:run(connection)
    if g_server ~= nil and connection ~= nil and not connection:getIsServer() then
        if self.placeable ~= nil and self.placeable.picServerStart ~= nil then
            self.placeable:picServerStart(self.itemIndex)
        end
        return
    end
end

function PIC_StartEvent.send(placeable, itemIndex)
    if g_server == nil then
        g_client:getServerConnection():sendEvent(PIC_StartEvent.new(placeable, itemIndex))
    else
        if placeable and placeable.picServerStart then
            placeable:picServerStart(itemIndex)
        end
    end
end

------------------------------------------------------------
-- FINALIZE (сервер завершает готовку и перекладывает в ready)
------------------------------------------------------------
PIC_FinalizeEvent = {}
local PIC_FinalizeEvent_mt = Class(PIC_FinalizeEvent, Event)
InitEventClass(PIC_FinalizeEvent, "PIC_FinalizeEvent")

function PIC_FinalizeEvent.emptyNew()
    return Event.new(PIC_FinalizeEvent_mt)
end

function PIC_FinalizeEvent.new(placeable)
    local self = PIC_FinalizeEvent.emptyNew()
    self.placeable = placeable
    return self
end

function PIC_FinalizeEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
end

function PIC_FinalizeEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)
    self:run(connection)
end

function PIC_FinalizeEvent:run(connection)
    if g_server ~= nil and connection ~= nil and not connection:getIsServer() then
        if self.placeable ~= nil and self.placeable.picServerFinalizeIfReady ~= nil then
            self.placeable:picServerFinalizeIfReady()
        end
        return
    end
end

function PIC_FinalizeEvent.send(placeable)
    if g_server == nil then
        g_client:getServerConnection():sendEvent(PIC_FinalizeEvent.new(placeable))
    else
        if placeable and placeable.picServerFinalizeIfReady then
            placeable:picServerFinalizeIfReady()
        end
    end
end

------------------------------------------------------------
-- CONSUME (съесть готовое)
------------------------------------------------------------
PIC_ConsumeEvent = {}
local PIC_ConsumeEvent_mt = Class(PIC_ConsumeEvent, Event)
InitEventClass(PIC_ConsumeEvent, "PIC_ConsumeEvent")

function PIC_ConsumeEvent.emptyNew()
    return Event.new(PIC_ConsumeEvent_mt)
end

function PIC_ConsumeEvent.new(placeable, readyIndex)
    local self = PIC_ConsumeEvent.emptyNew()
    self.placeable  = placeable
    self.readyIndex = math.max(1, readyIndex or 1)
    return self
end

function PIC_ConsumeEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
    streamWriteUIntN(streamId, self.readyIndex, 16)
end

function PIC_ConsumeEvent:readStream(streamId, connection)
    self.placeable  = NetworkUtil.readNodeObject(streamId)
    self.readyIndex = streamReadUIntN(streamId, 16)
    self:run(connection)
end

function PIC_ConsumeEvent:run(connection)
    if g_server ~= nil and connection ~= nil and not connection:getIsServer() then
        if self.placeable ~= nil and self.placeable.picServerConsumeReady ~= nil then
            local farmId = connection.farmId or (g_currentMission and g_currentMission:getFarmId()) or 1
            local ok, payload = self.placeable:picServerConsumeReady(farmId, self.readyIndex)
            if ok and _G.FoodVendorGainHungerEvent and FoodVendorGainHungerEvent.sendToConnection then
                FoodVendorGainHungerEvent.sendToConnection(connection, payload or { hungerGain=0, vigorGain=0, kind="food" })
            end
        end
        return
    end
end

function PIC_ConsumeEvent.send(placeable, readyIndex)
    if g_server == nil then
        g_client:getServerConnection():sendEvent(PIC_ConsumeEvent.new(placeable, readyIndex))
    else
        local farmId = (g_currentMission and g_currentMission:getFarmId()) or 1
        if placeable and placeable.picServerConsumeReady then
            local ok, payload = placeable:picServerConsumeReady(farmId, readyIndex)
            if ok and _G.FoodVendorGainHungerEvent then
                FoodVendorGainHungerEvent.new(payload or { hungerGain=0, vigorGain=0, kind="food" }):run(nil)
            end
        end
    end
end

------------------------------------------------------------
-- TAKE (забрать готовое в инвентарь)
------------------------------------------------------------
PIC_TakeEvent = {}
local PIC_TakeEvent_mt = Class(PIC_TakeEvent, Event)
InitEventClass(PIC_TakeEvent, "PIC_TakeEvent")

function PIC_TakeEvent.emptyNew()
    return Event.new(PIC_TakeEvent_mt)
end

function PIC_TakeEvent.new(placeable, readyIndex)
    local self = PIC_TakeEvent.emptyNew()
    self.placeable  = placeable
    self.readyIndex = readyIndex or 1
    return self
end

function PIC_TakeEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
    streamWriteUIntN(streamId, self.readyIndex or 1, 16)
end

function PIC_TakeEvent:readStream(streamId, connection)
    self.placeable  = NetworkUtil.readNodeObject(streamId)
    self.readyIndex = streamReadUIntN(streamId, 16)
    self:run(connection)
end

function PIC_TakeEvent:run(connection)
    if g_server == nil or self.placeable == nil or self.placeable.picServerTakeToInventory == nil then
        return
    end

    local farmId = 1
    if HungerSystem and HungerSystem.getFarmIdFromConnection and connection ~= nil then
        farmId = HungerSystem.getFarmIdFromConnection(connection)
    elseif g_currentMission and g_currentMission.player then
        farmId = g_currentMission.player.farmId or 1
    end

    local ok, payload = self.placeable:picServerTakeToInventory(farmId, self.readyIndex)
    if not ok or not payload then
        return
    end

    local ev = PIC_AddInventoryClientEvent.new(payload)
    if connection ~= nil then
        connection:sendEvent(ev)
    else
        ev:run(nil)
    end

    PIC_StateSyncEvent.send(self.placeable)
end

------------------------------------------------------------
-- DISCARD (выкинуть выбранное готовое)
------------------------------------------------------------
PIC_DiscardEvent = {}
local PIC_DiscardEvent_mt = Class(PIC_DiscardEvent, Event)
InitEventClass(PIC_DiscardEvent, "PIC_DiscardEvent")

function PIC_DiscardEvent.emptyNew() return Event.new(PIC_DiscardEvent_mt) end
function PIC_DiscardEvent.new(placeable, readyIndex)
    local self = PIC_DiscardEvent.emptyNew()
    self.placeable = placeable
    self.readyIndex = math.max(1, readyIndex or 1)
    return self
end

function PIC_DiscardEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
    streamWriteUIntN(streamId, self.readyIndex, 16)
end

function PIC_DiscardEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)
    self.readyIndex = streamReadUIntN(streamId, 16)
    self:run(connection)
end

function PIC_DiscardEvent:run(connection)
    if g_server and connection and not connection:getIsServer() then
        if self.placeable and self.placeable.picServerDiscard then
            self.placeable:picServerDiscard(nil, self.readyIndex)
        end
    end
end

function PIC_DiscardEvent.send(placeable, readyIndex)
    if g_server == nil then
        g_client:getServerConnection():sendEvent(PIC_DiscardEvent.new(placeable, readyIndex))
    else
        if placeable and placeable.picServerDiscard then
            placeable:picServerDiscard(nil, readyIndex)
        end
    end
end

------------------------------------------------------------
-- УТИЛИТА: резолв иконки в абсолютный путь (на сервере!)
------------------------------------------------------------
local function resolveIconPath(relOrAbs)
    if not relOrAbs or relOrAbs == "" then return "" end
    if fileExists(relOrAbs) then return relOrAbs end

    local candidates = {}

    if PlaceableIngredientCooker and PlaceableIngredientCooker.modDirectory then
        table.insert(candidates, PlaceableIngredientCooker.modDirectory)
    end
    if g_currentModDirectory then
        table.insert(candidates, g_currentModDirectory)
    end

    if _G.HungerSystem and HungerSystem.modDirectory then
        table.insert(candidates, HungerSystem.modDirectory)
    end
    if _G.Inventory and Inventory.modDir then
        table.insert(candidates, Inventory.modDir)
    end

    for _, base in ipairs(candidates) do
        if base and base ~= "" then
            local full = Utils.getFilename(relOrAbs, base)
            if full and fileExists(full) then
                return full
            end
        end
    end

    return relOrAbs
end

------------------------------------------------------------
-- CLIENT EVENT: добавить предмет из IngredientCooker в инвентарь
------------------------------------------------------------
if _G.PIC_AddInventoryClientEvent == nil then
    PIC_AddInventoryClientEvent = {}
    local PIC_AddInventoryClientEvent_mt = Class(PIC_AddInventoryClientEvent, Event)

    InitEventClass(PIC_AddInventoryClientEvent, "PIC_AddInventoryClientEvent")

    function PIC_AddInventoryClientEvent.emptyNew()
        return Event.new(PIC_AddInventoryClientEvent_mt)
    end

    function PIC_AddInventoryClientEvent.new(payload)
        local self = PIC_AddInventoryClientEvent.emptyNew()
        self.payload = payload or {}
        return self
    end

    function PIC_AddInventoryClientEvent:writeStream(streamId, connection)
        local p = self.payload or {}

        streamWriteString(streamId, tostring(p.id   or ""))
        streamWriteString(streamId, tostring(p.name or ""))

        streamWriteString(streamId, tostring(p.icon or ""))

        streamWriteInt16(streamId, math.floor(p.hungerGain or 0))
        streamWriteInt16(streamId, math.floor(p.vigorGain  or 0))

        streamWriteString(streamId, tostring(p.kind        or "food"))
        streamWriteString(streamId, tostring(p.effectId    or ""))
        streamWriteString(streamId, tostring(p.effectsFile or ""))

        streamWriteUInt8(streamId, math.max(1, p.count or 1))
        streamWriteString(streamId, tostring(p.placeableTitle or ""))
    end

    function PIC_AddInventoryClientEvent:readStream(streamId, connection)
        local p = {}

        p.id           = streamReadString(streamId)
        p.name         = streamReadString(streamId)
        p.icon         = streamReadString(streamId)
        p.hungerGain   = streamReadInt16(streamId)
        p.vigorGain    = streamReadInt16(streamId)
        p.kind         = streamReadString(streamId)
        p.effectId     = streamReadString(streamId)
        p.effectsFile  = streamReadString(streamId)
        p.count        = streamReadUInt8(streamId)
        p.placeableTitle = streamReadString(streamId)

        self.payload = p
        self:run(connection)
    end

    function PIC_AddInventoryClientEvent:run(connection)
        local p = self.payload or {}
        if not _G.Inventory or not Inventory.API or not Inventory.API.addItemInstance then
            print("[PIC] Inventory API not found")
            return
        end

        local baseId = p.id
        if baseId == "" then baseId = nil end

        local iconRel = p.icon or ""
        local iconAbs = iconRel

        if iconRel ~= "" then
            if Inventory and Inventory.modDir then
                local candidate = Utils.getFilename(iconRel, Inventory.modDir)
                if candidate and fileExists(candidate) then
                    iconAbs = candidate
                end
            end

            if (iconAbs == iconRel or not fileExists(iconAbs)) and g_currentModDirectory then
                local candidate = Utils.getFilename(iconRel, g_currentModDirectory)
                if candidate and fileExists(candidate) then
                    iconAbs = candidate
                end
            end

            if (iconAbs == iconRel or not fileExists(iconAbs)) and PlaceableIngredientCooker and PlaceableIngredientCooker.modDirectory then
                local candidate = Utils.getFilename(iconRel, PlaceableIngredientCooker.modDirectory)
                if candidate and fileExists(candidate) then
                    iconAbs = candidate
                end
            end
        end

        print(("[PIC] AddInv from cooker: name='%s' H=%d V=%d icon='%s' → resolved='%s'"):format(
            tostring(p.name), p.hungerGain or 0, p.vigorGain or 0, iconRel, iconAbs ~= iconRel and iconAbs or "FAILED"
        ))

        local count = math.max(1, p.count or 1)
        for i = 1, count do
            Inventory.API.addItemInstance({
                id          = baseId,
                name        = p.name or "Food",
                desc        = "",
                icon        = iconAbs,
                kind        = (p.kind == "effect") and "effect" or "food",
                hungerGain  = p.hungerGain or 0,
                vigorGain   = p.vigorGain  or 0,
                effectId    = p.effectId or "",
                effectsFile = p.effectsFile or ""
            })
        end
    end
end

------------------------------------------------------------
-- REQUEST STATE (клиент просит сервер выслать текущее состояние)
------------------------------------------------------------
PIC_StateSyncRequestEvent = {}
local PIC_StateSyncRequestEvent_mt = Class(PIC_StateSyncRequestEvent, Event)
InitEventClass(PIC_StateSyncRequestEvent, "PIC_StateSyncRequestEvent")

function PIC_StateSyncRequestEvent.emptyNew()
    return Event.new(PIC_StateSyncRequestEvent_mt)
end

function PIC_StateSyncRequestEvent.new(placeable)
    local self = PIC_StateSyncRequestEvent.emptyNew()
    self.placeable = placeable
    return self
end

function PIC_StateSyncRequestEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
end

function PIC_StateSyncRequestEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)
    self:run(connection)
end

function PIC_StateSyncRequestEvent:run(connection)
    if g_server ~= nil and connection ~= nil and not connection:getIsServer() then
        if self.placeable ~= nil and PIC_StateSyncEvent ~= nil and PIC_StateSyncEvent.new ~= nil then
            connection:sendEvent(PIC_StateSyncEvent.new(self.placeable))
        end
    end
end

------------------------------------------------------------
-- STATE SYNC (рассылка состояния cooker)
------------------------------------------------------------
PIC_StateSyncEvent = {}
local PIC_StateSyncEvent_mt = Class(PIC_StateSyncEvent, Event)
InitEventClass(PIC_StateSyncEvent, "PIC_StateSyncEvent")

function PIC_StateSyncEvent.emptyNew()
    return Event.new(PIC_StateSyncEvent_mt)
end

function PIC_StateSyncEvent.new(placeable)
    local self = PIC_StateSyncEvent.emptyNew()
    self.placeable = placeable
    return self
end

function PIC_StateSyncEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)

    local p    = self.placeable
    local spec = p and p.spec_ingredientCooker or nil

    local cooking      = spec and spec.state and spec.state.cooking or false
    local endTimeMs    = (spec and spec.state and spec.state.endTimeMs) or 0
    local currentIndex = (spec and spec.state and spec.state.current and spec.state.current.index) or 0

    local now         = g_time or 0
    local remainingMs = 0
    if cooking and endTimeMs > now then
        remainingMs = endTimeMs - now
    end

    streamWriteBool(streamId, cooking)
    streamWriteInt32(streamId, remainingMs)
    streamWriteInt32(streamId, currentIndex)

    local readyItems = (spec and spec.readyItems) or {}
    streamWriteUInt16(streamId, #readyItems)
    for _, it in ipairs(readyItems) do
        streamWriteInt32(streamId, it.index or 0)
        streamWriteInt16(streamId, it.hungerGain or 0)
        streamWriteInt16(streamId, it.vigorGain or 0)
        streamWriteInt16(streamId, it.resultCount or 1)
    end
end

function PIC_StateSyncEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)

    local p = self.placeable
    if not p or not p.spec_ingredientCooker then
        return
    end

    local spec = p.spec_ingredientCooker

    local cooking     = streamReadBool(streamId)
    local remainingMs = streamReadInt32(streamId)
    local curIdx      = streamReadInt32(streamId)

    spec.state.cooking = cooking

    if cooking and remainingMs > 0 then
        spec.state.endTimeMs = (g_time or 0) + remainingMs
    else
        spec.state.endTimeMs = 0
    end

    if curIdx > 0 and spec.items and spec.items[curIdx] then
        spec.state.current = spec.items[curIdx]
        spec.state.current.index = curIdx
    else
        spec.state.current = nil
    end

    spec.readyItems  = {}
    spec.readyCounts = {}

    local numReady = streamReadUInt16(streamId)
    for i = 1, numReady do
        local idx    = streamReadInt32(streamId)
        local hunger = streamReadInt16(streamId)
        local vigor  = streamReadInt16(streamId)
        local resCt  = streamReadInt16(streamId)

        table.insert(spec.readyItems, {
            index       = idx,
            hungerGain  = hunger,
            vigorGain   = vigor,
            resultCount = resCt
        })

        if idx ~= nil and idx > 0 then
            spec.readyCounts[idx] = (spec.readyCounts[idx] or 0) + 1
        end
    end

    spec.readyCount  = #spec.readyItems
    spec.state.ready = spec.readyCount > 0
end

function PIC_StateSyncEvent:run(connection)
    if not self.placeable or not self.placeable.spec_ingredientCooker then
        return
    end

    local p    = self.placeable
    local spec = p.spec_ingredientCooker

    if p._picApplyCookAnimFromState then
        p:_picApplyCookAnimFromState()
    end

    if IngredientCookerHUD and IngredientCookerHUD.INSTANCE
        and IngredientCookerHUD.INSTANCE.placeable == p
        and g_gui and g_gui:getIsGuiVisible() then

        local hud = IngredientCookerHUD.INSTANCE

        if hud.pullData then
            hud:pullData(true)
        end

        if hud.itemsTable and hud.itemsTable.reloadData then
            hud.itemsTable:reloadData(true)

            if hud.selectedIndex and hud.selectedIndex > 0
                and hud.itemsTable.setSelectedIndex then
                hud.itemsTable:setSelectedIndex(hud.selectedIndex, true, true)
            end
        end

        if hud.updateStatus   then hud:updateStatus()   end
        if hud.updateButtons  then hud:updateButtons()  end
        if hud.updateRecipeInfo then hud:updateRecipeInfo() end
    end
end

function PIC_StateSyncEvent.send(placeable)
    if g_server ~= nil then
        g_server:broadcastEvent(PIC_StateSyncEvent.new(placeable), nil, nil, placeable)
    end
end