-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 12.11.2025

---------------------------
-- helpers
---------------------------
local function _clamp(v, lo, hi)
    v  = tonumber(v)  or 0
    lo = tonumber(lo) or v
    hi = tonumber(hi) or v
    if v < lo then return lo end
    if v > hi then return hi end
    return v
end

---------------------------
-- SELECT/PLAY
---------------------------
MC_SelectTrackEvent = {}
local MC_SelectTrackEvent_mt = Class(MC_SelectTrackEvent, Event)
InitEventClass(MC_SelectTrackEvent, "MC_SelectTrackEvent")

function MC_SelectTrackEvent.emptyNew()
    return Event.new(MC_SelectTrackEvent_mt)
end

function MC_SelectTrackEvent.new(placeable, index)
    local self = MC_SelectTrackEvent.emptyNew()
    self.placeable = placeable
    self.index     = math.max(1, index or 1)
    return self
end

function MC_SelectTrackEvent:writeStream(streamId, _connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
    streamWriteUIntN(streamId, self.index, 16)
end

function MC_SelectTrackEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)
    self.index     = streamReadUIntN(streamId, 16)
    self:run(connection)
end

function MC_SelectTrackEvent:run(connection)
    if g_server == nil then
        if self.placeable and self.placeable.mcPlayLocal then
            self.placeable:mcPlayLocal(self.index)
        end
        return
    end

    if connection ~= nil and not connection:getIsServer() then
        if self.placeable and self.placeable.mcServerPlay then
            self.placeable:mcServerPlay(self.index)
        end
    end
end

function MC_SelectTrackEvent.send(placeable, index)
    if g_server ~= nil then
        g_server:broadcastEvent(MC_SelectTrackEvent.new(placeable, index), nil, nil, placeable)
    else
        g_client:getServerConnection():sendEvent(MC_SelectTrackEvent.new(placeable, index))
    end
end

---------------------------
-- STOP
---------------------------
MC_StopEvent = {}
local MC_StopEvent_mt = Class(MC_StopEvent, Event)
InitEventClass(MC_StopEvent, "MC_StopEvent")

function MC_StopEvent.emptyNew() return Event.new(MC_StopEvent_mt) end

function MC_StopEvent.new(placeable)
    local self = MC_StopEvent.emptyNew()
    self.placeable = placeable
    return self
end

function MC_StopEvent:writeStream(streamId, _connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
end

function MC_StopEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)
    self:run(connection)
end

function MC_StopEvent:run(connection)
    if g_server == nil then
        if self.placeable and self.placeable.mcStopLocal then
            self.placeable:mcStopLocal(false)
        end
        return
    end

    if connection ~= nil and not connection:getIsServer() then
        if self.placeable and self.placeable.mcServerStop then
            self.placeable:mcServerStop()
        end
    end
end

function MC_StopEvent.send(placeable)
    if g_server ~= nil then
        g_server:broadcastEvent(MC_StopEvent.new(placeable), nil, nil, placeable)
    else
        g_client:getServerConnection():sendEvent(MC_StopEvent.new(placeable))
    end
end

---------------------------
-- CHANGE MODE
---------------------------
MC_ChangeModeEvent = {}
local MC_ChangeModeEvent_mt = Class(MC_ChangeModeEvent, Event)
InitEventClass(MC_ChangeModeEvent, "MC_ChangeModeEvent")

function MC_ChangeModeEvent.emptyNew() return Event.new(MC_ChangeModeEvent_mt) end

function MC_ChangeModeEvent.new(placeable, mode)
    local self = MC_ChangeModeEvent.emptyNew()
    self.placeable = placeable
    self.mode      = _clamp(mode or 1, 1, 4)
    return self
end

function MC_ChangeModeEvent:writeStream(streamId, _connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
    streamWriteUIntN(streamId, _clamp(self.mode or 1, 1, 4), 3)
end

function MC_ChangeModeEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)
    self.mode      = _clamp(streamReadUIntN(streamId, 3), 1, 4)
    self:run(connection)
end

function MC_ChangeModeEvent:run(connection)
    if g_server == nil then
        if self.placeable and self.placeable.mcSetModeLocal then
            self.placeable:mcSetModeLocal(self.mode)
        end
        return
    end
    if connection ~= nil and not connection:getIsServer() then
        if self.placeable and self.placeable.mcServerSetMode then
            self.placeable:mcServerSetMode(self.mode)
        end
    end
end

function MC_ChangeModeEvent.send(placeable, mode)
    local m = _clamp(mode or 1, 1, 4)
    if g_server ~= nil then
        g_server:broadcastEvent(MC_ChangeModeEvent.new(placeable, m), nil, nil, placeable)
    else
        g_client:getServerConnection():sendEvent(MC_ChangeModeEvent.new(placeable, m))
    end
end
