-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 11.11.2025

function Inventory.Hud.init(Inv, Hud, Dialogs, I18n)
  Hud.isVisible = false
  Hud.gridCols = Inv.gridCols
  Hud.gridRows = Inv.gridRows
  Hud.cellPx   = 85
  Hud.items    = {}
  Hud.hover    = nil

  local gapX, gapY = getNormalizedScreenValues(3, 3)
  Hud._gapX, Hud._gapY = gapX, gapY

  Hud._btnClose = {x=0,y=0,w=0,h=0, hover=false}
  Hud._info = {x=0,y=0,w=0,h=0}

  -- иконки
  Hud._hungerPath = Inventory.modDir .. "gui/icon/hunger.dds"
  Hud._vigorPath  = Inventory.modDir .. "gui/icon/vigor.dds"

  function Hud:refresh()
    for i=1, Inv.maxSlots do Hud.items[i] = Inv.items[i] end
  end

  local function _isMissingText(t)
    if type(t) ~= "string" then return false end
    local s = string.lower(t)
    return string.find(s, "missing '") ~= nil and string.find(s, " in ") ~= nil and string.find(s, ".xml") ~= nil
  end
  local modEnv = g_i18n and g_i18n.modEnvironments and g_i18n.modEnvironments[Inventory.modName] or nil
  local modTexts = (modEnv and modEnv.texts) or nil
  local function _tryGet(key)
    if not key or key == "" then return nil end
    if modTexts and modTexts[key] and modTexts[key] ~= "" then return modTexts[key] end
    if g_i18n and g_i18n.getText then
      local v = g_i18n:getText(key)
      if v and v ~= "" and v ~= key and not _isMissingText(v) then return v end
    end
    return nil
  end
  local function _resolve(text, fallback)
    if text == nil or text == "" then return fallback end
    if type(text) ~= "string" then return tostring(text) end
    local s = text
    if s:sub(1,1) == "$" then s = s:sub(2) end
    local v = _tryGet(s); if v then return v end
    if s:sub(1,5) == "l10n_" then v = _tryGet(s:sub(6)); if v then return v end end
    if _isMissingText(text) then return fallback end
    return text or fallback
  end

  function Hud:getCellRect(col,row)
    local w,h = getNormalizedScreenValues(Hud.cellPx, Hud.cellPx)
    local gridW = Hud.gridCols*w + (Hud.gridCols-1)*Hud._gapX
    local gridH = Hud.gridRows*h + (Hud.gridRows-1)*Hud._gapY
    local pad = getNormalizedScreenValues(12, 12)

    local infoH   = 0.078
    local gapGridToInfo = 0.008
    local btnH    = 0.04
    local gapInfoToBtn  = 0.014
    local bottomZone = gapGridToInfo + infoH + gapInfoToBtn + btnH + 0.010

    local bodyW, bodyH = gridW + pad*2, gridH + pad*2 + 0.09 + bottomZone
    local bodyX = 0.5 - bodyW/2
    local bodyY = 0.5 - (bodyH/2)

    Hud._bodyX, Hud._bodyY, Hud._bodyW, Hud._bodyH = bodyX, bodyY, bodyW, bodyH

    Hud._gridX, Hud._gridY, Hud._gridW, Hud._gridH =
      bodyX + pad, bodyY + pad + bottomZone, gridW, gridH

    Hud._info.x = Hud._gridX
    Hud._info.w = Hud._gridW
    Hud._info.h = infoH
    Hud._info.y = Hud._gridY - gapGridToInfo - infoH

    -- кнопка «Закрыть»
	Hud._btnClose.w, Hud._btnClose.h = 0.095, btnH * 0.9
	Hud._btnClose.x = bodyX + bodyW - Hud._btnClose.w - 0.006
	Hud._btnClose.y = bodyY + 0.022

    local x = Hud._gridX + (col-1)*(w + Hud._gapX)
    local y = Hud._gridY + (Hud.gridRows-row)*(h + Hud._gapY)
    return x,y,w,h
  end

  local function slotAt(H,x,y)
    for i=1, H.gridCols*H.gridRows do
      local col = ((i-1) % H.gridCols) + 1
      local row = math.floor((i-1)/H.gridCols) + 1
      local cx,cy,cw,ch = H:getCellRect(col,row)
      if x>=cx and x<=cx+cw and y>=cy and y<=cy+ch then
        return i
      end
    end
    return nil
  end

  local function pointIn(b,x,y) return x>=b.x and x<=b.x+b.w and y>=b.y and y<=b.y+b.h end

  function Hud:mouseMove(x,y,isDown,isUp,button)
    Hud.hover = slotAt(Hud, x,y)
    Hud._btnClose.hover = pointIn(Hud._btnClose, x,y)
  end

  function Hud:onMouseClick(x,y)
    if pointIn(Hud._btnClose, x,y) then
      Inventory:hideHud()
      return
    end
    local slot = slotAt(Hud, x,y)
    if not slot then return end
    local it = Inv.items[slot]; if not it then return end
    if Inventory.API.consume(it) then
      Inventory.API.removeAt(slot)
    end
  end

  function Hud:onRightClick(x,y)
    local slot = slotAt(Hud, x,y)
    if not slot then return end
    if not Inv.items[slot] then return end
    Inventory.API.removeAt(slot)
  end

  function Hud:render()
    Hud:getCellRect(1,1)

    -- фон и рамка
    drawFilledRect(0,0,1,1, table.unpack(Inv.Const.COLORS.BG_DIM))
    drawFilledRect(Hud._bodyX, Hud._bodyY, Hud._bodyW, Hud._bodyH, table.unpack(Inv.Const.COLORS.BG))
    drawFilledRect(Hud._bodyX, Hud._bodyY+Hud._bodyH-0.06, Hud._bodyW, 0.06, table.unpack(Inv.Const.COLORS.BLACK))
    setTextAlignment(RenderText.ALIGN_CENTER); setTextBold(true); setTextColor(1,1,1,1)
    renderText(Hud._bodyX + Hud._bodyW/2, Hud._bodyY+Hud._bodyH-0.035, getCorrectTextSize(0.016), I18n:t("INVENTORY_TITLE"))

    -- подложка под сетку
    drawFilledRect(Hud._gridX, Hud._gridY, Hud._gridW, Hud._gridH, 0,0,0,0.55)

    -- слоты
    for i=1, Hud.gridCols*Hud.gridRows do
      local col = ((i-1) % Hud.gridCols) + 1
      local row = math.floor((i-1)/Hud.gridCols) + 1
      local x,y,w,h = Hud:getCellRect(col,row)
      local isHover = (Hud.hover == i)
      drawFilledRect(x, y, w, h, table.unpack(isHover and Inv.Const.COLORS.ACCENT_HOVER or Inv.Const.COLORS.BLACK))

      local it = Inv.items[i]
      if it then
        -- иконка предмета
        if it.icon and it.icon ~= "" and fileExists(it.icon) then
          local pad = math.min(w, h) * 0.08
          local boxW, boxH = w - pad*2, h - pad*2
          local side = math.min(boxW, boxH) * 0.9
          local ix = x + pad + (boxW - side) * 0.5
          local iy = y + pad + (boxH - side) * 0.5
          local ov = Overlay.new(it.icon, ix, iy, side, side)
          ov:render(); ov:delete()
        end

        -- H / V внизу слева — иконка + число
        local s      = math.min(w, h)
        local iconSz = s * 0.15
        local baseX  = x + s * 0.07
        local baseY  = y + s * 0.07

        -- Сытость
        if fileExists(Hud._hungerPath) then
          local oh = Overlay.new(Hud._hungerPath, baseX, baseY, iconSz, iconSz)
          oh:render(); oh:delete()
        end
        local txtSize = getCorrectTextSize(0.0090)
        setTextAlignment(RenderText.ALIGN_LEFT); setTextBold(true); setTextColor(1,1,1,1)
        local hStr = string.format("%+d", tonumber(it.hungerGain or 0))
        local hTextX = baseX + iconSz + (s * 0.035)
        renderText(hTextX, baseY + iconSz * 0.20, txtSize, hStr)

        local hTextW = getTextWidth and getTextWidth(txtSize, hStr) or 0.035
        local vX = hTextX + hTextW + (s * 0.06)

        -- Бодрость
        if fileExists(Hud._vigorPath) then
          local ov = Overlay.new(Hud._vigorPath, vX, baseY, iconSz, iconSz)
          ov:render(); ov:delete()
        end
        local vStr = string.format("%+d", tonumber(it.vigorGain or 0))
        renderText(vX + iconSz + (s * 0.035), baseY + iconSz * 0.20, txtSize, vStr)

      else
        setTextAlignment(RenderText.ALIGN_CENTER); setTextColor(1,1,1,0.15)
        renderText(x + w/2, y + h/2, getCorrectTextSize(0.0080), "—")
      end
    end

    drawFilledRect(Hud._info.x, Hud._info.y, Hud._info.w, Hud._info.h, 0,0,0,0.45)
    local it = (Hud.hover and Inv.items[Hud.hover]) or nil
    if it then
      local padX = 0.014
      local title = _resolve(it.name, "")
      local desc  = _resolve(it.desc, "")

      if title and title ~= "" and not _isMissingText(title) then
        setTextAlignment(RenderText.ALIGN_LEFT); setTextBold(true); setTextColor(1,1,1,1)
        renderText(Hud._info.x + padX, Hud._info.y + Hud._info.h - 0.028, getCorrectTextSize(0.015), title)
      end

      if desc and desc ~= "" and not _isMissingText(desc) then
        setTextAlignment(RenderText.ALIGN_LEFT); setTextBold(false); setTextColor(1,1,1,0.85)
        local short = tostring(desc)
        if short:len() > 180 then short = short:sub(1,177) .. "..." end
        renderText(Hud._info.x + padX, Hud._info.y + 0.018, getCorrectTextSize(0.012), short)
      end
    else
      setTextAlignment(RenderText.ALIGN_CENTER); setTextBold(false); setTextColor(1,1,1,0.45)
      renderText(Hud._info.x + Hud._info.w/2, Hud._info.y + Hud._info.h/2 - 0.008, getCorrectTextSize(0.012), "—")
    end

    -- Кнопка «Закрыть»
    local bc = Hud._btnClose.hover and Inv.Const.COLORS.BTN_HOVER or Inv.Const.COLORS.BTN
    drawFilledRect(Hud._btnClose.x, Hud._btnClose.y, Hud._btnClose.w, Hud._btnClose.h, table.unpack(bc))
    setTextAlignment(RenderText.ALIGN_CENTER); setTextBold(true); setTextColor(1,1,1,1)
    renderText(Hud._btnClose.x + Hud._btnClose.w/2, Hud._btnClose.y + Hud._btnClose.h*0.33, getCorrectTextSize(0.013), I18n:t("INVENTORY_BTN_CLOSE"))

    -- подсказка
    setTextAlignment(RenderText.ALIGN_CENTER); setTextColor(1,1,1,0.65)
    renderText(Hud._bodyX + Hud._bodyW/2, Hud._bodyY-0.026, getCorrectTextSize(0.0115), I18n:t("INVENTORY_HINT"))
  end
end
