-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 11.11.2025

HungerDrowsyDriverRegister = {}
HungerDrowsyDriverRegister.modName      = g_currentModName or "unknown"
HungerDrowsyDriverRegister.modDirectory = g_currentModDirectory or ""

g_specializationManager:addSpecialization(
    "hungerDrowsyDriver",
    "HungerDrowsyDriver",
    Utils.getFilename("scripts/DrowsyDriver/HungerDrowsyDriver.lua", HungerDrowsyDriverRegister.modDirectory),
    nil
)
print("[HungerDrowsyDriverRegister] Registered specialization 'hungerDrowsyDriver'")

local function inject()
    local cnt = 0
    local vtm = g_vehicleTypeManager
    local types = (vtm and (vtm.types or vtm.vehicleTypes)) or {}
    for typeName, vType in pairs(types) do
        local specs = vType.specializations
        if specs
            and SpecializationUtil.hasSpecialization(Enterable, specs)
            and not SpecializationUtil.hasSpecialization(HungerDrowsyDriver, specs)
        then
            g_vehicleTypeManager:addSpecialization(typeName, "hungerDrowsyDriver")
            cnt = cnt + 1
        end
    end
    print(string.format("[HungerDrowsyDriverRegister] Injected into %d vehicle types", cnt))
end

inject()
