-- Author: U_BMP
-- Group: vk.com/https://vk.com/biomodprod_utilit_fs
-- Date: 11.11.2025

local function clamp01(x) if not x then return 0 end if x<0 then return 0 elseif x>1 then return 1 else return x end end

HungerDrowsyActionEvent = {}
local HungerDrowsyActionEvent_mt = Class(HungerDrowsyActionEvent, Event)
InitEventClass(HungerDrowsyActionEvent, "HungerDrowsyActionEvent")

function HungerDrowsyActionEvent.emptyNew()
    return Event.new(HungerDrowsyActionEvent_mt)
end


function HungerDrowsyActionEvent.new(vehicle, severity, axisSide, holdMs)
    local self = HungerDrowsyActionEvent.emptyNew()
    self.vehicle   = vehicle
    self.severity  = clamp01(severity or 0)
    self.axisSide  = axisSide or 0.0
    self.holdMs    = holdMs or 0
    return self
end

function HungerDrowsyActionEvent:readStream(streamId, connection)
    self.vehicle  = NetworkUtil.readNodeObject(streamId)
    self.severity = clamp01(streamReadFloat32(streamId))
    self.axisSide = streamReadFloat32(streamId)
    self.holdMs   = streamReadUInt16(streamId)
    self:run(connection)
end

function HungerDrowsyActionEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteFloat32(streamId, self.severity)
    streamWriteFloat32(streamId, self.axisSide)
    streamWriteUInt16(streamId, self.holdMs)
end

function HungerDrowsyActionEvent:run(connection)
    local v = self.vehicle
    if v == nil or not v:getIsSynchronized() then return end

    if not connection:getIsServer() and g_server ~= nil then
        g_server:broadcastEvent(HungerDrowsyActionEvent.new(v, self.severity, self.axisSide, self.holdMs), nil, connection, v)
    end

    local spec = v.spec_hungerDrowsyDriver
    if not spec then return end

    spec.jerkAxisSide = self.axisSide
    spec.activeUntil  = (g_time or 0) + (self.holdMs or 0)
end

function HungerDrowsyActionEvent.send(vehicle, severity, axisSide, holdMs)
    if g_server ~= nil then
        g_server:broadcastEvent(HungerDrowsyActionEvent.new(vehicle, severity, axisSide, holdMs), nil, nil, vehicle)
    else
        local conn = g_client and g_client:getServerConnection()
        if conn ~= nil then
            conn:sendEvent(HungerDrowsyActionEvent.new(vehicle, severity, axisSide, holdMs))
        end
    end
end
