source(Utils.getFilename("scripts/events/SetIsReconfiguringEvent.lua", g_currentModDirectory))
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "ExtendedChangeVehicleConfigEvent.lua")

ExtendedChangeVehicleConfigEvent = {}

function ExtendedChangeVehicleConfigEvent:run(connection)
    if not connection:getIsServer() then
		local vehicle = self.vehicle
        local condition = vehicle == nil or (not vehicle.isVehicleSaved or vehicle.getIsControlled ~= nil and vehicle:getIsControlled()) or not g_currentMission:getHasPlayerPermission("buyVehicle", connection)
		if not condition then
            vehicle.isReconfiguring = true
            if vehicle ~= nil then
                log:printDevInfo(string.format("ExtendedChangeVehicleConfigEvent:run - Sending SetIsReconfiguringEvent for vehicle %s", vehicle:getName()), LoggingUtil.DEBUG_LEVELS.HIGH)
                connection:sendEvent(SetIsReconfiguringEvent.new(vehicle, true))
            end
        end
    end
end

ChangeVehicleConfigEvent.run = Utils.prependedFunction(ChangeVehicleConfigEvent.run, ExtendedChangeVehicleConfigEvent.run)