--[[
    HookLiftContainerExtension

    Reworks the HookLiftContainer to disable automatic attachment of hoses.

	@author: 		BayernGamers
	@date: 			10.09.2025
	@version:		1.0

	History:		v1.0 @10.09.2025 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------

	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage:
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))
source(Utils.getFilename("scripts/AttachImplementsManuallySettingsManager.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "HookLiftContainerExtension.lua")

HookLiftContainerExtension = {}
HookLiftContainerExtension.MOD_DIRECTORY = g_currentModDirectory
HookLiftContainerExtension.MOD_NAME = g_currentModName

function HookLiftContainerExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(HookLiftContainer, specializations)
end

function HookLiftContainerExtension.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", HookLiftContainerExtension)
    ExtendedSpecializationUtil.registerOverwrittenEventListener(vehicleType, "onLoad", HookLiftContainer, HookLiftContainerExtension)
end

function HookLiftContainerExtension.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "onHookLiftContainerLockChanged", HookLiftContainerExtension.onHookLiftContainerLockChanged)
end

--TODO: Check if manual hose attachment is enabled in settings
function HookLiftContainerExtension:onPreLoad(savegame)
	self.spec_hookLiftContainerExtension = {}

	local spec = self.spec_hookLiftContainerExtension
	spec.modSettingsManager = AttachImplementsManuallySettingsManager.getInstance()
end

function HookLiftContainerExtension:onLoad(savegame)
	local spec = self.spec_hookLiftContainerExtension
	local spec_hookLiftContainer = self.spec_hookLiftContainer

	spec_hookLiftContainer.tiltContainerOnDischarge = self.xmlFile:getValue("vehicle.hookLiftContainer#tiltContainerOnDischarge", true)
	spec_hookLiftContainer.visualReferenceNodeStart = self.xmlFile:getValue("vehicle.hookLiftContainer.visualRollReference#startNode", nil, self.components, self.i3dMappings)
	spec_hookLiftContainer.visualReferenceNodeEnd = self.xmlFile:getValue("vehicle.hookLiftContainer.visualRollReference#endNode", nil, self.components, self.i3dMappings)
	spec_hookLiftContainer.containerLockChangeObjects = {}
	ObjectChangeUtil.loadObjectChangeFromXML(self.xmlFile, "vehicle.hookLiftContainer.containerLock", spec_hookLiftContainer.containerLockChangeObjects, self.components, self)
	ObjectChangeUtil.setObjectChanges(spec_hookLiftContainer.containerLockChangeObjects, false, self, self.setMovingToolDirty)

	if not spec.modSettingsManager:getEnableAttachImplementsManually() then
		if self.setConnectionHosesActive ~= nil then
			self:setConnectionHosesActive(false)
		end
	end
end

function HookLiftContainerExtension:onHookLiftContainerLockChanged(superFunc, state)
	local spec = self.spec_hookLiftContainerExtension
	local spec_hookLiftContainer = self.spec_hookLiftContainer

	if not spec.modSettingsManager:getEnableAttachImplementsManually() then
		if self.setConnectionHosesActive ~= nil and self:getAttacherVehicle():getImplementByObject(self) ~= nil then
			self:setConnectionHosesActive(state)
		end
	end

	ObjectChangeUtil.setObjectChanges(spec_hookLiftContainer.containerLockChangeObjects, state, self, self.setMovingToolDirty)
end
