--[[
    AttachableBrakeExtension

    Reworks the attachable's behavior to be aware of attach implements manually.

	@author: 		BayernGamers
	@date: 			09.06.2025
	@version:		1.0

	History:		v1.0 @09.06.2025 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------

	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage:
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "AttachableBrakeExtension.lua")

AttachableBrakeExtension = {}
AttachableBrakeExtension.MOD_DIRECTORY = g_currentModDirectory
AttachableBrakeExtension.MOD_NAME = g_currentModName           

function AttachableBrakeExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations) and SpecializationUtil.hasSpecialization(ConnectionHoses, specializations)
end

function AttachableBrakeExtension.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", AttachableBrakeExtension)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", AttachableBrakeExtension)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", AttachableBrakeExtension)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", AttachableBrakeExtension)
end

function AttachableBrakeExtension:onPreLoad(savegame)
    self.spec_attachableBrakeExtension = {}
end

function AttachableBrakeExtension:onLoad(savegame)
    local spec = self.spec_attachableBrakeExtension

    spec.hasConnectionHoses = false
    spec.modSettingsManager = AttachImplementsManuallySettingsManager.getInstance()
end

function AttachableBrakeExtension:onPostLoad(savegame)
    local spec = self.spec_attachableBrakeExtension
    local spec_connectionHoses = self.spec_connectionHoses

    spec.hasConnectionHoses = #spec_connectionHoses.toolConnectorHoses > 0 or #spec_connectionHoses.hoseNodes > 0 or #spec_connectionHoses.customHoseTargets > 0 or #spec_connectionHoses.customHoses > 0
end

function AttachableBrakeExtension:onUpdateTick(dt)
    local spec = self.spec_attachableBrakeExtension

    if spec.hasConnectionHoses then
        local attacherVehicle = self:getAttacherVehicle()

        if attacherVehicle ~= nil then 
            if spec.hasConnectionHoses then
                if attacherVehicle ~= nil then
                    local implementIndex = attacherVehicle:getImplementIndexByObject(self)
                    local jointDescIndex = attacherVehicle:getAttacherJointIndexFromImplementIndex(implementIndex)

                    if jointDescIndex ~= nil and attacherVehicle.spec_attachConnectionHosesManually ~= nil and attacherVehicle.spec_attachConnectionHosesManually.attachedHoses ~= nil then
                        if attacherVehicle.spec_attachConnectionHosesManually.attachedHoses[jointDescIndex] == nil then
                            if self.brake ~= nil then
                                local brakeForce = self:getBrakeForce()
                                if brakeForce > 0 then
                                    log:printDevInfo("Applying brake force " .. tostring(brakeForce) .. " to attacher vehicle " .. tostring(self:getName()), LoggingUtil.DEBUG_LEVELS.MEDIUM)
                                    self:brake(brakeForce, true)
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end