--[[
Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 04.01.2019
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]


PlaceableTransferOwnershipPoint = {}

PlaceableTransferOwnershipPoint.MOD_NAME = g_currentModName
PlaceableTransferOwnershipPoint.SPEC_NAME = string.format("%s.transferOwnershipPoint", g_currentModName)
PlaceableTransferOwnershipPoint.SPEC = string.format("spec_%s", PlaceableTransferOwnershipPoint.SPEC_NAME)

local specEntryName = PlaceableTransferOwnershipPoint.SPEC

function PlaceableTransferOwnershipPoint.prerequisitesPresent(specializations)
    return true
end

function PlaceableTransferOwnershipPoint.registerOverwrittenFunctions(placeableType)
    SpecializationUtil.registerOverwrittenFunction(placeableType, "setPreviewPosition", PlaceableTransferOwnershipPoint.setPreviewPosition)
    SpecializationUtil.registerOverwrittenFunction(placeableType, "setShowMarkers", PlaceableTransferOwnershipPoint.setShowMarkers)
end

function PlaceableTransferOwnershipPoint.registerEventListeners(placeableType)
    SpecializationUtil.registerEventListener(placeableType, "onLoad", PlaceableTransferOwnershipPoint)
    SpecializationUtil.registerEventListener(placeableType, "onFinalizePlacement", PlaceableTransferOwnershipPoint)
    SpecializationUtil.registerEventListener(placeableType, "onDelete", PlaceableTransferOwnershipPoint)
end

function PlaceableTransferOwnershipPoint.registerFunctions(placeableType)
    SpecializationUtil.registerFunction(placeableType, "getTransferOwnershipPoint", PlaceableTransferOwnershipPoint.getTransferOwnershipPoint)
end

function PlaceableTransferOwnershipPoint.registerXMLPaths(schema, basePath)
    schema:setXMLSpecializationType("TransferOwnershipPoint")

    TransferOwnershipPoint.registerXMLPaths(schema, basePath)

    schema:register(XMLValueType.NODE_INDEX, basePath .. ".transferOwnership.triggerMarker(?)#node", "Trigger marker node")
    schema:register(XMLValueType.BOOL, basePath .. ".transferOwnership.triggerMarker(?)#adjustToGround", "Trigger marker adjusted to ground")
    schema:register(XMLValueType.FLOAT, basePath .. ".transferOwnership.triggerMarker(?)#groundOffset", "Offset above the ground height if adjustToGround is enabled", 0.03)

    schema:setXMLSpecializationType()
end

function PlaceableTransferOwnershipPoint:onLoad()
    local spec = self[specEntryName]
    local xmlFile = self.xmlFile

    local transferPoint = TransferOwnershipPoint.new()

    transferPoint.owningPlaceable = self
    transferPoint.baseDirectory = self.baseDirectory
    transferPoint.customEnvironment = self.customEnvironment

    if transferPoint:load(self.components, xmlFile, "placeable", self.i3dMappings) then
        spec.transferPoint = transferPoint
    else
        transferPoint:delete()
    end

    spec.triggerMarkers = {}

    xmlFile:iterate("placeable.transferOwnership.triggerMarker", function (_, key)
        local node = xmlFile:getValue(key .. "#node", nil, self.components, self.i3dMappings)

        if node ~= nil then
            setVisibility(node, true)

            table.insert(spec.triggerMarkers, {
                adjustToGround = xmlFile:getValue(key .. "#adjustToGround", false),
                groundOffset = xmlFile:getValue(key .. "#groundOffset", 0.02),
                node = node
            })
        else
            Logging.xmlWarning(xmlFile, "Missing trigger marker node for '%s'", key)
        end
    end)

    if #spec.triggerMarkers == 0 then
        spec.triggerMarkers = nil
    end
end

function PlaceableTransferOwnershipPoint:onFinalizePlacement()
    local spec = self[specEntryName]

    if spec.transferPoint ~= nil then
        spec.transferPoint:finalizePlacement()
    end

    if spec.triggerMarkers ~= nil then
        local terrainRootNode = g_currentMission.terrainRootNode

        for _, marker in ipairs(spec.triggerMarkers) do
            if marker.adjustToGround then
                local nx, ny, nz = getWorldTranslation(marker.node)

                ny = getTerrainHeightAtWorldPos(terrainRootNode, nx, 0, nz) + marker.groundOffset
                setWorldTranslation(marker.node, nx, ny, nz)
            end
        end
    end
end

function PlaceableTransferOwnershipPoint:onDelete()
    local spec = self[specEntryName]

    if spec.transferPoint ~= nil then
        spec.transferPoint:delete()
        spec.transferPoint = nil
    end
end

function PlaceableTransferOwnershipPoint:setShowMarkers(superFunc, doShow)
    superFunc(self, g_currentMission:getFarmId() ~= FarmManager.SPECTATOR_FARM_ID)
end

function PlaceableTransferOwnershipPoint:setPreviewPosition(superFunc, ...)
    superFunc(self, ...)

    local spec = self[specEntryName]

    if spec.triggerMarkers ~= nil then
        local terrainRootNode = g_currentMission.terrainRootNode

        for _, marker in ipairs(spec.triggerMarkers) do
            if marker.adjustToGround then
                local nx, ny, nz = getWorldTranslation(marker.node)

                ny = getTerrainHeightAtWorldPos(terrainRootNode, nx, 0, nz) + marker.groundOffset
                setWorldTranslation(marker.node, nx, ny, nz)
            end
        end
    end

    local triggerMarkersSpec = self.spec_triggerMarkers

    if triggerMarkersSpec ~= nil and triggerMarkersSpec.triggerMarkers ~= nil then
        for _, marker in ipairs(triggerMarkersSpec.triggerMarkers) do
            setVisibility(marker.node, true)
        end
    end
end

function PlaceableTransferOwnershipPoint:getTransferOwnershipPoint()
    return self[specEntryName].transferPoint
end
