AbstractBaleObject = PlaceableObjectStorage.ABSTRACT_OBJECTS_BY_CLASS_NAME["Bale"]
function AbstractBaleObject:removeFromStorage(storage, x, y, z, rx, ry, rz, spawnedCallback)
	local baleObject = nil

	if self.baleObject ~= nil then
		addToPhysics(self.baleObject.nodeId)
		setVisibility(self.baleObject.nodeId, true)

		local quatX, quatY, quatZ, quatW = mathEulerToQuaternion(rx, ry, rz)

		self.baleObject:setLocalPositionQuaternion(x, y, z, quatX, quatY, quatZ, quatW, true)
		self.baleObject:register()
		g_currentMission.itemSystem:addItemToSave(self.baleObject)

		baleObject = self.baleObject
	else
		baleObject = Bale.new(storage.isServer, storage.isClient)

		if baleObject:loadFromConfigXML(self.baleAttributes.xmlFilename, x, y, z, rx, ry, rz) then
			baleObject:applyBaleAttributes(self.baleAttributes)
			baleObject:register()
		end
	end

	if baleObject.isRoundbale then
		removeFromPhysics(baleObject.nodeId)
		rotateAboutLocalAxis(baleObject.nodeId, math.pi * 0.5, 1, 0, 0)
		addToPhysics(baleObject.nodeId)
	end

	-- set owner to storage owner
	baleObject:setOwnerFarmId(storage:getOwnerFarmId() or AccessHandler.EVERYONE)

	g_farmManager:updateFarmStats(storage:getOwnerFarmId(), "storedBales", -1)
	spawnedCallback(storage, baleObject)
end
