AutoTipTrailer = {}
AutoTipTrailer.__index = AutoTipTrailer

function AutoTipTrailer.prerequisitesPresent(specializations)
    return true
end

function AutoTipTrailer.initSpecialization()
end

function AutoTipTrailer.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", AutoTipTrailer)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", AutoTipTrailer)
end

function AutoTipTrailer:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
        local _, actionEventId = self:addActionEvent(InputAction.ACTION_EXTRA3, self, AutoTipTrailer.onXPressed, false, true, false, true)
        g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_LOW)
        g_inputBinding:setActionEventText(actionEventId, "Mini-Abladevorgang (1,5s)")
    end
end

function AutoTipTrailer:onXPressed(actionName, keyStatus, isDown, isUp, isPressed)
    if isPressed and not self.autoTipRunning then
        -- Heckklappe zu 10 % öffnen
        self:setAnimationTime("tipAnimationBack", 0.1, false)
        
        -- Start Abladevorgang (1,5 Sek.)
        if self:getCanToggleTipState() then
            self:toggleTipState()
            self.autoTipRunning = true
            self.autoTipStartTime = g_time
        end
    end
end

function AutoTipTrailer:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    if self.autoTipRunning then
        if g_time - self.autoTipStartTime >= 1500 then
            -- Zeit vorbei, Entladung stoppen
            self.autoTipRunning = false
            -- Optional: Heckklappe schließen oder Info anzeigen
        end
    end
end
