HerbicideMixing = {}

function HerbicideMixing:GetShouldDrawInfo()
    if g_localPlayer:getCurrentVehicle() ~= nil then

        if g_localPlayer:getCurrentVehicle().IsMixing then
            return true
        end

        if g_localPlayer:getCurrentVehicle().getAttachedImplements ~= nil then
            for _, impl in pairs(g_localPlayer:getCurrentVehicle():getAttachedImplements()) do
                if impl.object.IsMixing then
                    return true
                end
            end
        end
    end

    return false
end

function HerbicideMixing:GetIsMixingPosible(SprayerObject)
    local InternalSprayFillLevel = SprayerObject:getFillUnitFillLevel(SprayerObject:getSprayerFillUnitIndex())
    local InternalFillType = SprayerObject:getFillUnitFillType(SprayerObject:getSprayerFillUnitIndex())
    local IsMixingNow = false

    if not (InternalFillType == FillType.HERBICIDE or InternalFillType == FillType.LIQUIDFERTILIZER) then
        return false
    end
   
    if InternalSprayFillLevel > 0 then
        for _, supportedSprayType in ipairs(SprayerObject.spec_sprayer.supportedSprayTypes) do
            for _, src in ipairs(SprayerObject.spec_sprayer.fillTypeSources[supportedSprayType]) do
                if src.vehicle:getIsFillUnitActive(src.fillUnitIndex) then
                    local vehicleFillType = src.vehicle:getFillUnitFillType(src.fillUnitIndex)
                    local vehicleFillLevel = src.vehicle:getFillUnitFillLevel(src.fillUnitIndex)

                    local sprayVehicleFillUnitIndex = src.fillUnitIndex
                    local fillType = src.vehicle:getFillUnitFillType(sprayVehicleFillUnitIndex)

                    if vehicleFillLevel > 0 then
                        if fillType == FillType.HERBICIDE or fillType == FillType.LIQUIDFERTILIZER then
                            if fillType ~= InternalFillType then
                                SprayerObject.MixingTankVehicle = src.vehicle;
                                SprayerObject.MixingTankFillUnitIndex = sprayVehicleFillUnitIndex;
                                SprayerObject.MixingTankFillType = fillType;
                                return true
                            end
                        end
                    end
                end
            end
        end
    end

    return false
end

function HerbicideMixing:GetMixInFillType(SprayerObject)
    local InternalFillType = SprayerObject:getFillUnitFillType(SprayerObject:getSprayerFillUnitIndex())

    if InternalFillType == FillType.HERBICIDE then 
        return FillType.LIQUIDFERTILIZER;
    end

    if InternalFillType == FillType.LIQUIDFERTILIZER then 
        return FillType.HERBICIDE;
    end

    return FillType.UNKNOWN;
end

function HerbicideMixing:getText(OldFunc, name, customEnv)
    if name == "info_workWidthAndUsage" or name == "info_workWidth" then
        if HerbicideMixing.MixInFillType ~= nil and g_fillTypeManager:getFillTypeByIndex(HerbicideMixing.MixInFillType) ~= nil then
            return OldFunc(self, name, customEnv) .. " | " .. g_i18n:getText("text_Mixing")..": "..g_fillTypeManager:getFillTypeByIndex(HerbicideMixing.MixInFillType).title  
        end
    end

    return OldFunc(self, name, customEnv)
end

function HerbicideMixing:draw(OldFunc, ...)

    if not HerbicideMixing:GetShouldDrawInfo() then
        return OldFunc(self, ...);
    end

    local OldI18NFunc = I18N.getText;
    I18N.getText = Utils.overwrittenFunction(I18N.getText, HerbicideMixing.getText)
    local Returning = OldFunc(self, ...)
    I18N.getText = OldI18NFunc;

    return Returning
end

function HerbicideMixing:onEndWorkAreaProcessing(OldFunc, ...)
    local spec = self.spec_sprayer

    if self.isServer and spec.workAreaParameters.isActive and self.IsMixing then
        if self.MixingTankVehicle ~= nil and self.MixingTankFillUnitIndex ~= nil and self.MixingTankFillType ~= nil then
            local usage = spec.workAreaParameters.usage
            if self:getIsSprayerExternallyFilled() then
                local price = usage * g_currentMission.economyManager:getCostPerLiter(self.MixingTankFillType, false);
                g_currentMission:addMoney(-price, self:getOwnerFarmId(), MoneyType.PURCHASE_FERTILIZER)
            else
                self.MixingTankVehicle:addFillUnitFillLevel(
                    self:getOwnerFarmId(),
                    self.MixingTankFillUnitIndex,
                    -usage,
                    self.MixingTankFillType,
                    ToolType.UNDEFINED,
                    nil
                )
            end
        end
    end

    return OldFunc(self, ...)
end

function HerbicideMixing:onUpdateTick(OldFunc, ...)
    local Returning = OldFunc(self, ...)

    self.IsMixing = HerbicideMixing:GetIsMixingPosible(self)

    if self.IsMixing and g_localPlayer:getCurrentVehicle() == self.rootVehicle then
        HerbicideMixing.MixInFillType = HerbicideMixing:GetMixInFillType(self);
    end

    return Returning
end

function HerbicideMixing:processSprayerArea(OldFunc, workArea, dt)
    local spec = self.spec_sprayer

    if spec.isManureSpreader then
        return OldFunc(self, workArea, dt);
    end

    if self.IsMixing == nil or self.IsMixing == false then
        return OldFunc(self, workArea, dt);
    end

    if self:getIsAIActive() and self.isServer and (spec.workAreaParameters.sprayFillType == nil or spec.workAreaParameters.sprayFillType == FillType.UNKNOWN) then
        local rootVehicle = self.rootVehicle

        rootVehicle:stopCurrentAIJob(AIMessageErrorOutOfFill.new())

        return 0, 0
    end

    if spec.workAreaParameters.sprayFillLevel <= 0 then
        return 0, 0
    end

    local sx, _, sz = getWorldTranslation(workArea.start)
    local wx, _, wz = getWorldTranslation(workArea.width)
    local hx, _, hz = getWorldTranslation(workArea.height)
    local sprayAmount = self:getSprayerDoubledAmountActive(spec.workAreaParameters.sprayType) and 2 or 1

    local changedArea, totalArea = FSDensityMapUtil.updateSprayArea(sx, sz, wx, wz, hx, hz, spec.workAreaParameters.sprayType, sprayAmount)

    local SprayType = g_sprayTypeManager:getSprayTypeByIndex(spec.workAreaParameters.sprayType)

    if self.IsMixing ~= nil and self.IsMixing then
        if SprayType.isHerbicide then
            local lq = g_sprayTypeManager:getSprayTypeIndexByFillTypeIndex(FillType.LIQUIDFERTILIZER)
            FSDensityMapUtil.updateSprayArea(sx, sz, wx, wz, hx, hz, lq, sprayAmount)
        elseif SprayType.isFertilizer then
            local lq = g_sprayTypeManager:getSprayTypeIndexByFillTypeIndex(FillType.HERBICIDE)
            FSDensityMapUtil.updateSprayArea(sx, sz, wx, wz, hx, hz, lq, sprayAmount)
        end
    end

    spec.workAreaParameters.isActive = true
    spec.workAreaParameters.lastChangedArea = spec.workAreaParameters.lastChangedArea + changedArea
    spec.workAreaParameters.lastStatsArea = spec.workAreaParameters.lastStatsArea + changedArea
    spec.workAreaParameters.lastTotalArea = spec.workAreaParameters.lastTotalArea + totalArea
    spec.workAreaParameters.lastSprayTime = g_time

    if self:getLastSpeed() > 1 then
        spec.isWorking = true
    end

    return changedArea, totalArea
end

function HerbicideMixing:updateActionEvents(OldFunc, ...)
    local Returning = OldFunc(self, ...)

    if HerbicideMixing:GetShouldDrawInfo() then
        for _, event in ipairs(g_inputBinding:getEventsForActionName("UNLOAD")) do
            g_inputBinding:setActionEventActive(event.id, false)
        end
    end

    return Returning;
end

VariableWorkWidthHUDExtension.draw = Utils.overwrittenFunction(VariableWorkWidthHUDExtension.draw, HerbicideMixing.draw)
Sprayer.onEndWorkAreaProcessing = Utils.overwrittenFunction(Sprayer.onEndWorkAreaProcessing, HerbicideMixing.onEndWorkAreaProcessing)
Sprayer.onUpdateTick = Utils.overwrittenFunction(Sprayer.onUpdateTick, HerbicideMixing.onUpdateTick)
Sprayer.processSprayerArea = Utils.overwrittenFunction(Sprayer.processSprayerArea, HerbicideMixing.processSprayerArea)
Dischargeable.updateActionEvents =  Utils.overwrittenFunction(Dischargeable.updateActionEvents, HerbicideMixing.updateActionEvents)
