-- HeadtrackingCameraSuspension.lua
-- FS25 Compatible
-- Author: Gerb

HeadtrackingCameraSuspension = {}

--- Called when the camera suspension setting changes
-- @param bool newState new setting state
function HeadtrackingCameraSuspension:onActiveCameraSuspensionSettingChanged(superFunc, newState)
    -- Debug log
    print("HeadtrackingCameraSuspension (FS25): Suspension state changed to " .. tostring(newState))

    if self.suspensionNode ~= nil then
        if self.lastActiveCameraSuspensionSetting ~= newState then
            if newState then
                link(self.cameraSuspensionParentNode, self.cameraPositionNode)
            else
                link(self.cameraBaseParentNode, self.cameraPositionNode)
            end

            -- Ensure headTrackingNode is properly linked
            if self.headTrackingNode ~= nil then
                link(getParent(self.cameraPositionNode), self.headTrackingNode)
            end

            self.lastActiveCameraSuspensionSetting = newState
        end
    end
end

VehicleCamera.onActiveCameraSuspensionSettingChanged = Utils.overwrittenFunction(
    VehicleCamera.onActiveCameraSuspensionSettingChanged,
    HeadtrackingCameraSuspension.onActiveCameraSuspensionSettingChanged
)
