EAS_LivestockTrailer = {}

function EAS_LivestockTrailer.addAnimals(self, superFunc, subTypeIndex, numAnimals, age)
    local cluster = g_currentMission.animalSystem:createClusterFromSubTypeIndex(subTypeIndex)
    local subType = g_currentMission.animalSystem:getSubTypeByIndex(subTypeIndex)
    local neededAge = subType.reproductionMinAgeMonth + subType.reproductionDurationMonth

	if cluster:getSupportsMerging() then
		cluster.numAnimals = numAnimals
		cluster.age = age

        if age >= neededAge then
            cluster.hadABirth = true
        end

		self:addCluster(cluster)
	else
		for i = 1, numAnimals do
			if i > 1 then
				cluster = g_currentMission.animalSystem:createClusterFromSubTypeIndex(subTypeIndex)
			end

			cluster.numAnimals = 1
			cluster.age = age

            if age >= neededAge then
                cluster.hadABirth = true
            end

			self:addCluster(cluster)
		end
	end
end

LivestockTrailer.addAnimals = Utils.overwrittenFunction(LivestockTrailer.addAnimals, EAS_LivestockTrailer.addAnimals)