EAS_InseminationManager = {}

function EAS_InseminationManager.collectInseminationCost(spec, numAnimals)
    local farmId = spec:getOwnerFarmId()
    local farm = g_farmManager:getFarmById(farmId)

    if farm == nil then
		Logging.warning("Husbandry has no farm")
        return
    end

    local price = EAS_InseminationManager.priceForInseminated(spec.animalTypeIndex)
    local totalCost = price * numAnimals
    local moneyType = MoneyType.ANIMAL_UPKEEP

    if g_currentMission:getIsServer() then
        farm:changeBalance(-totalCost, moneyType)
        g_currentMission:addMoneyChange(-totalCost, farmId, moneyType, true)
    else
        g_client:getServerConnection():sendEvent(EAS_RemoveMoneyEvent.new(farmId, totalCost, moneyType))
    end
end

function EAS_InseminationManager.priceForInseminated(animalTypeIndex)
    local animalType = g_currentMission.animalSystem:getTypeByIndex(animalTypeIndex)
    return animalType.inseminationCost
end