EAS_AnimalSystem = {}

EAS_AnimalSystem.cowsPath = g_currentModDirectory .. "xmls/cows.xml"
EAS_AnimalSystem.pigsPath = g_currentModDirectory .. "xmls/pigs.xml"
EAS_AnimalSystem.sheepsPath = g_currentModDirectory .. "xmls/sheeps.xml"
EAS_AnimalSystem.horsesPath = g_currentModDirectory .. "xmls/horses.xml"
EAS_AnimalSystem.chickensPath = g_currentModDirectory .. "xmls/chickens.xml"
EAS_AnimalSystem.animalsPath = {
    EAS_AnimalSystem.cowsPath,
    EAS_AnimalSystem.pigsPath,
    EAS_AnimalSystem.sheepsPath,
    EAS_AnimalSystem.horsesPath,
    EAS_AnimalSystem.chickensPath
}

local EAS_AnimalSystem_mt = Class(EAS_AnimalSystem)

function EAS_AnimalSystem.new(customMt)
	local self = setmetatable({}, customMt or EAS_AnimalSystem_mt)
	self.isServer = false
	self.mission = false

    self.animals = {}

    for _, path in pairs(EAS_AnimalSystem.animalsPath) do
        EAS_AnimalSystem.loadAnimalsXml(self, path)
    end

	return self
end

function EAS_AnimalSystem.loadAnimalsXml(self, path)
	local xmlFile = XMLFile.wrap(loadXMLFile("animals", path))

    xmlFile:iterate("animals.animal", function (_, animalKey)
        local animal = {
            inseminationCost = xmlFile:getInt(animalKey .. "#inseminationCost", 15),
            maxAge = xmlFile:getInt(animalKey .. "#maxAge", 150),
            maxAgeDiePercentage = xmlFile:getInt(animalKey .. "#maxAgeDiePercentage", 5),
            healthEmptyDiePercentage = xmlFile:getInt(animalKey .. "#healthEmptyDiePercentage", 3)
        }
        local subTypes = {}

        xmlFile:iterate(animalKey..".subType", function (_, subTypeKey)
            local subType = {
                reproductionProbabilities = {},
                inseminationProbabilities = {},
                inseminationTooOldAge = xmlFile:getInt(subTypeKey .. ".inseminationProbabilities#tooOldAge", 180),
                inseminationTooOldAgeSteps = xmlFile:getInt(subTypeKey .. ".inseminationProbabilities#steps", 8),
                lactation = {},
                malePart = xmlFile:getString(subTypeKey .. "#malePart")
            }

            xmlFile:iterate(subTypeKey..".reproduction.key", function (_, reproductionKey)
                local reproductionValue = {
                    numOfAnimals = xmlFile:getInt(reproductionKey .. "#numOfAnimals", 1),
                    probability = xmlFile:getInt(reproductionKey .. "#probability", 100)
                }

                table.insert(subType.reproductionProbabilities, reproductionValue)
            end)

            xmlFile:iterate(subTypeKey..".inseminationProbabilities.key", function (_, reproductionKey)
                local inseminationProbabilityValue = {
                    monthSinceLastBirth = xmlFile:getInt(reproductionKey .. "#monthSinceLastBirth", 0),
                    probability = xmlFile:getInt(reproductionKey .. "#probability", 100)
                }

                table.insert(subType.inseminationProbabilities, inseminationProbabilityValue)
            end)

            xmlFile:iterate(subTypeKey..".lactation.key", function (_, lactationKey)
                local lactationValue = {
                    month = xmlFile:getInt(lactationKey .. "#month", 0),
                    food = xmlFile:getFloat(lactationKey .. "#food", 1.0),
                    milk = xmlFile:getFloat(lactationKey .. "#milk", 1.0)
                }

                table.insert(subType.lactation, lactationValue)
            end)

            subTypes[xmlFile:getString(subTypeKey .. "#subType")] = subType
        end)

        animal.subTypes = subTypes
        self.animals[xmlFile:getString(animalKey .. "#type")] = animal
    end)

    xmlFile:delete()
end

function EAS_AnimalSystem:addSubTypeProperties(animalTypName, subType)
    local easAnimalType = self.animals[animalTypName]
    local easSubType = easAnimalType.subTypes[subType.name]

    if easSubType == nil then
        return
    end

    subType.malePart = easSubType.malePart
    subType.lactation = easSubType.lactation
    subType.inseminationTooOldAge = easSubType.inseminationTooOldAge
    subType.inseminationTooOldAgeSteps = easSubType.inseminationTooOldAgeSteps

    self:addReproductionProbabilities(subType, easSubType)
    self:addInseminationProbabilities(subType, easSubType)
end

function EAS_AnimalSystem:addReproductionProbabilities(subType, easSubType)
    subType.reproductionProbabilities = easSubType.reproductionProbabilities
    local repoductionProbabilitiesMap = {}
    for _, probabilityValue in pairs(easSubType.reproductionProbabilities) do
        for i = 1, probabilityValue.probability do
            table.insert(repoductionProbabilitiesMap, probabilityValue.numOfAnimals)
        end
    end
    subType.repoductionProbabilitiesMap = repoductionProbabilitiesMap
end

function EAS_AnimalSystem:addInseminationProbabilities(subType, easSubType)
    subType.inseminationProbabilities = easSubType.inseminationProbabilities
    local inseminationProbabilitiesMap = {}
    for _, inseminationProbabilityValue in pairs(easSubType.inseminationProbabilities) do
        inseminationProbabilitiesMap[inseminationProbabilityValue.monthSinceLastBirth] = inseminationProbabilityValue.probability
    end
    subType.inseminationProbabilitiesMap = inseminationProbabilitiesMap
end

function EAS_AnimalSystem:addAnimalTypeProperties(animalType)
    local easAnimalType = self.animals[animalType.name]

    animalType.inseminationCost = easAnimalType.inseminationCost
    animalType.maxAge = easAnimalType.maxAge
    animalType.maxAgeDiePercentage = easAnimalType.maxAgeDiePercentage
    animalType.healthEmptyDiePercentage = easAnimalType.healthEmptyDiePercentage
end

------------------------------------------------------

function EAS_AnimalSystem.loadSubType(self, superFunc, animalType, subType, xmlFile, subTypeKey, baseDirectory)
    local returnValue = superFunc(self, animalType, subType, xmlFile, subTypeKey, baseDirectory)
    g_eas_animalSystem:addSubTypeProperties(animalType.name, subType)
    subType.reproductionMinHealth = 0
    return returnValue
end

AnimalSystem.loadSubType = Utils.overwrittenFunction(AnimalSystem.loadSubType, EAS_AnimalSystem.loadSubType)

function EAS_AnimalSystem.loadAnimalConfig(self, superFunc, animalType, baseDirectory)
    local returnValue = superFunc(self, animalType, baseDirectory)
    g_eas_animalSystem:addAnimalTypeProperties(animalType)
    return returnValue
end

AnimalSystem.loadAnimalConfig = Utils.overwrittenFunction(AnimalSystem.loadAnimalConfig, EAS_AnimalSystem.loadAnimalConfig)

g_eas_animalSystem = EAS_AnimalSystem.new()