--Sandmann
--21/05/2025

-- Deaktiviert die Walz-Anforderung für bestimmte Früchte nach realer Praxis
-- Kompatibel mit Precision Farming

-- Disables rolling requirement for certain crops based on real-world practice
-- Compatible with Precision Farming

CropDependentRolling = {}

function CropDependentRolling.disableRollingForFruits()
    -- List of crop types that do NOT require rolling (edit as needed)
    local excludedFruitTypes = {
        "maize", "sunflower", "cotton", "sorghum", "poplar", "oilseedRadish"
    }

    for _, fruitName in ipairs(excludedFruitTypes) do
        local fruitType = g_fruitTypeManager:getFruitTypeByName(fruitName)
        if fruitType ~= nil then
            fruitType.needsRolling = false
            print(string.format("[CropDependentRolling] needsRolling disabled for: %s", fruitName))
        else
            print(string.format("[CropDependentRolling] Warning: fruitType '%s' not found", fruitName))
        end
    end
end

local function onLoadMapFinished(mission, ...)
    CropDependentRolling.disableRollingForFruits()
end

FSBaseMission.loadMapFinished = Utils.appendedFunction(FSBaseMission.loadMapFinished, onLoadMapFinished)
